/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib;

import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import me.tofaa.entitylib.EntityLib;
import org.jetbrains.annotations.NotNull;

public final class APIConfig {
    private final PacketEventsAPI<?> packetEvents;
    private boolean debugMode = false;
    private boolean checkForUpdates = false;
    private boolean tickTickables = false;
    private boolean platformLogger = false;
    private boolean bstats = true;
    private boolean forceBundle = false;

    public APIConfig(PacketEventsAPI<?> packetEvents) {
        this.packetEvents = packetEvents;
    }

    @NotNull
    public APIConfig useBstats() {
        this.bstats = true;
        return this;
    }

    @NotNull
    public APIConfig disableBStats() {
        this.bstats = false;
        return this;
    }

    @NotNull
    public APIConfig forceBundles() {
        this.forceBundle = true;
        return this;
    }

    @NotNull
    public APIConfig usePlatformLogger() {
        this.platformLogger = true;
        return this;
    }

    @NotNull
    public APIConfig checkForUpdates() {
        this.checkForUpdates = true;
        return this;
    }

    @NotNull
    public APIConfig tickTickables() {
        this.tickTickables = true;
        return this;
    }

    @NotNull
    public APIConfig debugMode() {
        this.debugMode = true;
        return this;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean shouldCheckForUpdate() {
        return this.checkForUpdates;
    }

    public boolean shouldTickTickables() {
        return this.tickTickables;
    }

    public PacketEventsAPI<?> getPacketEvents() {
        return this.packetEvents;
    }

    public boolean shouldUsePlatformLogger() {
        return this.platformLogger;
    }

    public boolean shouldUseBstats() {
        return this.bstats;
    }

    public boolean shouldForceBundles() {
        return this.forceBundle && EntityLib.getOptionalApi().isPresent() && EntityLib.getOptionalApi().get().getPacketEvents().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_19_4);
    }
}

