/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.common;

import com.github.retrooper.packetevents.PacketEventsAPI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import me.tofaa.entitylib.APIConfig;
import me.tofaa.entitylib.EntityLibAPI;
import me.tofaa.entitylib.Platform;
import me.tofaa.entitylib.UserLocaleProvider;
import me.tofaa.entitylib.container.EntityContainer;
import me.tofaa.entitylib.tick.TickContainer;
import me.tofaa.entitylib.wrapper.WrapperEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityLibAPI<P, T>
implements EntityLibAPI<T> {
    protected final Platform<P> platform;
    protected final PacketEventsAPI<?> packetEvents;
    protected final APIConfig settings;
    protected final Collection<TickContainer<?, T>> tickContainers;
    protected final EntityContainer defaultEntityContainer = EntityContainer.basic();

    protected AbstractEntityLibAPI(Platform<P> platform, APIConfig settings) {
        this.platform = platform;
        this.packetEvents = settings.getPacketEvents();
        this.settings = settings;
        this.tickContainers = settings.shouldTickTickables() ? new HashSet() : Collections.emptyList();
    }

    @Override
    @Nullable
    public WrapperEntity getEntity(int id) {
        return this.defaultEntityContainer.getEntity(id);
    }

    @Override
    @Nullable
    public WrapperEntity getEntity(@NotNull UUID uuid) {
        return this.defaultEntityContainer.getEntity(uuid);
    }

    @Override
    @NotNull
    public Collection<WrapperEntity> getAllEntities() {
        return this.defaultEntityContainer.getEntities();
    }

    @Override
    @NotNull
    public EntityContainer getDefaultContainer() {
        return this.defaultEntityContainer;
    }

    @Override
    @NotNull
    public APIConfig getSettings() {
        return this.settings;
    }

    @Override
    public PacketEventsAPI<?> getPacketEvents() {
        return this.packetEvents;
    }

    @Override
    @NotNull
    public Collection<TickContainer<?, T>> getTickContainers() {
        return this.tickContainers;
    }

    @Override
    @NotNull
    public UserLocaleProvider getUserLocaleProvider() {
        return this.platform.getUserLocaleProvider();
    }
}

