/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.container;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.tofaa.entitylib.container.EntityContainer;
import me.tofaa.entitylib.wrapper.WrapperEntity;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityContainer
implements EntityContainer {
    private final Map<UUID, WrapperEntity> entities = new ConcurrentHashMap<UUID, WrapperEntity>();
    private final Map<Integer, WrapperEntity> entitiesById = new ConcurrentHashMap<Integer, WrapperEntity>();

    @Override
    public void addEntity(WrapperEntity entity) {
        this.entities.put(entity.getUuid(), entity);
        this.entitiesById.put(entity.getEntityId(), entity);
    }

    @Override
    public void removeEntity(WrapperEntity entity, boolean despawn) {
        this.entities.remove(entity.getUuid());
        this.entitiesById.remove(entity.getEntityId());
        if (despawn) {
            entity.despawn();
        }
    }

    @Override
    public void removeEntity(int entityId, boolean despawn) {
        WrapperEntity entity = this.entitiesById.get(entityId);
        if (entity != null) {
            this.removeEntity(entity, despawn);
        }
    }

    @Override
    public void removeEntity(UUID uuid, boolean despawn) {
        WrapperEntity entity = this.entities.get(uuid);
        if (entity != null) {
            this.removeEntity(entity, despawn);
        }
    }

    @Override
    public void clearEntities(boolean despawn) {
        this.entities.values().forEach(entity -> this.removeEntity((WrapperEntity)entity, despawn));
    }

    @Override
    public void tick() {
    }

    @Override
    @NotNull
    public Iterator<WrapperEntity> iterator() {
        return this.entities.values().iterator();
    }

    @Override
    public Collection<WrapperEntity> getEntities() {
        return Collections.unmodifiableCollection(this.entities.values());
    }

    @Override
    public WrapperEntity getEntity(UUID uuid) {
        return this.entities.get(uuid);
    }

    @Override
    public WrapperEntity getEntity(int entityId) {
        return this.entitiesById.get(entityId);
    }

    @Override
    public boolean containsEntity(UUID uuid) {
        return this.entities.containsKey(uuid);
    }

    @Override
    public boolean containsEntity(int entityId) {
        return this.entitiesById.containsKey(entityId);
    }

    @Override
    public boolean containsEntity(WrapperEntity entity) {
        return this.entities.containsValue(entity);
    }
}

