/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta;

import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import me.tofaa.entitylib.meta.EntityMeta;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.display.BlockDisplayMeta;
import me.tofaa.entitylib.meta.display.ItemDisplayMeta;
import me.tofaa.entitylib.meta.display.TextDisplayMeta;
import me.tofaa.entitylib.meta.mobs.BatMeta;
import me.tofaa.entitylib.meta.mobs.BeeMeta;
import me.tofaa.entitylib.meta.mobs.DonkeyMeta;
import me.tofaa.entitylib.meta.mobs.FoxMeta;
import me.tofaa.entitylib.meta.mobs.FrogMeta;
import me.tofaa.entitylib.meta.mobs.GoatMeta;
import me.tofaa.entitylib.meta.mobs.HoglinMeta;
import me.tofaa.entitylib.meta.mobs.OcelotMeta;
import me.tofaa.entitylib.meta.mobs.PandaMeta;
import me.tofaa.entitylib.meta.mobs.PolarBearMeta;
import me.tofaa.entitylib.meta.mobs.SnifferMeta;
import me.tofaa.entitylib.meta.mobs.StriderMeta;
import me.tofaa.entitylib.meta.mobs.cuboid.MagmaCubeMeta;
import me.tofaa.entitylib.meta.mobs.cuboid.SlimeMeta;
import me.tofaa.entitylib.meta.mobs.golem.IronGolemMeta;
import me.tofaa.entitylib.meta.mobs.golem.ShulkerMeta;
import me.tofaa.entitylib.meta.mobs.golem.SnowGolemMeta;
import me.tofaa.entitylib.meta.mobs.horse.CamelMeta;
import me.tofaa.entitylib.meta.mobs.horse.HorseMeta;
import me.tofaa.entitylib.meta.mobs.horse.LlamaMeta;
import me.tofaa.entitylib.meta.mobs.horse.MuleMeta;
import me.tofaa.entitylib.meta.mobs.horse.SkeletonHorseMeta;
import me.tofaa.entitylib.meta.mobs.horse.TraderLlamaMeta;
import me.tofaa.entitylib.meta.mobs.horse.ZombieHorseMeta;
import me.tofaa.entitylib.meta.mobs.minecart.ChestMinecartMeta;
import me.tofaa.entitylib.meta.mobs.minecart.CommandBlockMinecartMeta;
import me.tofaa.entitylib.meta.mobs.minecart.FurnaceMinecartMeta;
import me.tofaa.entitylib.meta.mobs.minecart.SpawnerMinecartMeta;
import me.tofaa.entitylib.meta.mobs.minecart.TntMinecartMeta;
import me.tofaa.entitylib.meta.mobs.monster.BlazeMeta;
import me.tofaa.entitylib.meta.mobs.monster.BreezeMeta;
import me.tofaa.entitylib.meta.mobs.monster.CaveSpiderMeta;
import me.tofaa.entitylib.meta.mobs.monster.CreeperMeta;
import me.tofaa.entitylib.meta.mobs.monster.ElderGuardianMeta;
import me.tofaa.entitylib.meta.mobs.monster.EndermanMeta;
import me.tofaa.entitylib.meta.mobs.monster.EndermiteMeta;
import me.tofaa.entitylib.meta.mobs.monster.GhastMeta;
import me.tofaa.entitylib.meta.mobs.monster.GiantMeta;
import me.tofaa.entitylib.meta.mobs.monster.GuardianMeta;
import me.tofaa.entitylib.meta.mobs.monster.PhantomMeta;
import me.tofaa.entitylib.meta.mobs.monster.SilverfishMeta;
import me.tofaa.entitylib.meta.mobs.monster.SpiderMeta;
import me.tofaa.entitylib.meta.mobs.monster.VexMeta;
import me.tofaa.entitylib.meta.mobs.monster.WardenMeta;
import me.tofaa.entitylib.meta.mobs.monster.WitherMeta;
import me.tofaa.entitylib.meta.mobs.monster.ZoglinMeta;
import me.tofaa.entitylib.meta.mobs.monster.piglin.PiglinBruteMeta;
import me.tofaa.entitylib.meta.mobs.monster.piglin.PiglinMeta;
import me.tofaa.entitylib.meta.mobs.monster.raider.EvokerMeta;
import me.tofaa.entitylib.meta.mobs.monster.raider.IllusionerMeta;
import me.tofaa.entitylib.meta.mobs.monster.raider.PillagerMeta;
import me.tofaa.entitylib.meta.mobs.monster.raider.RavagerMeta;
import me.tofaa.entitylib.meta.mobs.monster.raider.VindicatorMeta;
import me.tofaa.entitylib.meta.mobs.monster.raider.WitchMeta;
import me.tofaa.entitylib.meta.mobs.monster.skeleton.BoggedMeta;
import me.tofaa.entitylib.meta.mobs.monster.skeleton.SkeletonMeta;
import me.tofaa.entitylib.meta.mobs.monster.skeleton.StrayMeta;
import me.tofaa.entitylib.meta.mobs.monster.skeleton.WitherSkeletonMeta;
import me.tofaa.entitylib.meta.mobs.monster.zombie.DrownedMeta;
import me.tofaa.entitylib.meta.mobs.monster.zombie.HuskMeta;
import me.tofaa.entitylib.meta.mobs.monster.zombie.ZombieMeta;
import me.tofaa.entitylib.meta.mobs.monster.zombie.ZombieVillagerMeta;
import me.tofaa.entitylib.meta.mobs.monster.zombie.ZombifiedPiglinMeta;
import me.tofaa.entitylib.meta.mobs.passive.ArmadilloMeta;
import me.tofaa.entitylib.meta.mobs.passive.ChickenMeta;
import me.tofaa.entitylib.meta.mobs.passive.CowMeta;
import me.tofaa.entitylib.meta.mobs.passive.MooshroomMeta;
import me.tofaa.entitylib.meta.mobs.passive.PigMeta;
import me.tofaa.entitylib.meta.mobs.passive.RabbitMeta;
import me.tofaa.entitylib.meta.mobs.passive.SheepMeta;
import me.tofaa.entitylib.meta.mobs.passive.TurtleMeta;
import me.tofaa.entitylib.meta.mobs.tameable.CatMeta;
import me.tofaa.entitylib.meta.mobs.tameable.ParrotMeta;
import me.tofaa.entitylib.meta.mobs.tameable.WolfMeta;
import me.tofaa.entitylib.meta.mobs.villager.VillagerMeta;
import me.tofaa.entitylib.meta.mobs.villager.WanderingTraderMeta;
import me.tofaa.entitylib.meta.mobs.water.AxolotlMeta;
import me.tofaa.entitylib.meta.mobs.water.CodMeta;
import me.tofaa.entitylib.meta.mobs.water.DolphinMeta;
import me.tofaa.entitylib.meta.mobs.water.GlowSquidMeta;
import me.tofaa.entitylib.meta.mobs.water.PufferFishMeta;
import me.tofaa.entitylib.meta.mobs.water.SalmonMeta;
import me.tofaa.entitylib.meta.mobs.water.SquidMeta;
import me.tofaa.entitylib.meta.mobs.water.TropicalFishMeta;
import me.tofaa.entitylib.meta.other.AreaEffectCloudMeta;
import me.tofaa.entitylib.meta.other.ArmorStandMeta;
import me.tofaa.entitylib.meta.other.BoatMeta;
import me.tofaa.entitylib.meta.other.EndCrystalMeta;
import me.tofaa.entitylib.meta.other.EnderDragonMeta;
import me.tofaa.entitylib.meta.other.EvokerFangsMeta;
import me.tofaa.entitylib.meta.other.FallingBlockMeta;
import me.tofaa.entitylib.meta.other.FireworkRocketMeta;
import me.tofaa.entitylib.meta.other.FishingHookMeta;
import me.tofaa.entitylib.meta.other.GlowItemFrameMeta;
import me.tofaa.entitylib.meta.other.InteractionMeta;
import me.tofaa.entitylib.meta.other.ItemFrameMeta;
import me.tofaa.entitylib.meta.other.LeashKnotMeta;
import me.tofaa.entitylib.meta.other.LightningBoltMeta;
import me.tofaa.entitylib.meta.other.LlamaSpitMeta;
import me.tofaa.entitylib.meta.other.MarkerMeta;
import me.tofaa.entitylib.meta.other.PaintingMeta;
import me.tofaa.entitylib.meta.other.PrimedTntMeta;
import me.tofaa.entitylib.meta.other.TntMeta;
import me.tofaa.entitylib.meta.projectile.ArrowMeta;
import me.tofaa.entitylib.meta.projectile.DragonFireballMeta;
import me.tofaa.entitylib.meta.projectile.EyeOfEnderMeta;
import me.tofaa.entitylib.meta.projectile.ItemEntityMeta;
import me.tofaa.entitylib.meta.projectile.LargeFireballMeta;
import me.tofaa.entitylib.meta.projectile.ShulkerBulletMeta;
import me.tofaa.entitylib.meta.projectile.SmallFireballMeta;
import me.tofaa.entitylib.meta.projectile.SnowballMeta;
import me.tofaa.entitylib.meta.projectile.ThrownEggMeta;
import me.tofaa.entitylib.meta.projectile.ThrownEnderPearlMeta;
import me.tofaa.entitylib.meta.projectile.ThrownExpBottleMeta;
import me.tofaa.entitylib.meta.projectile.ThrownPotionMeta;
import me.tofaa.entitylib.meta.projectile.ThrownTridentMeta;
import me.tofaa.entitylib.meta.projectile.WitherSkullMeta;
import me.tofaa.entitylib.meta.types.LivingEntityMeta;
import me.tofaa.entitylib.meta.types.PlayerMeta;
import org.jetbrains.annotations.NotNull;

final class MetaConverterRegistry {
    private final Map<EntityType, BiFunction<Integer, Metadata, EntityMeta>> converters = new HashMap<EntityType, BiFunction<Integer, Metadata, EntityMeta>>();
    private final Map<EntityType, Class<? extends EntityMeta>> metaClasses = new HashMap<EntityType, Class<? extends EntityMeta>>();

    MetaConverterRegistry() {
        this.put(EntityTypes.ABSTRACT_WIND_CHARGE, SmallFireballMeta.class, SmallFireballMeta::new);
        this.put(EntityTypes.AREA_EFFECT_CLOUD, AreaEffectCloudMeta.class, AreaEffectCloudMeta::new);
        this.put(EntityTypes.ALLAY, LivingEntityMeta.class, LivingEntityMeta::new);
        this.put(EntityTypes.ARMADILLO, ArmadilloMeta.class, ArmadilloMeta::new);
        this.put(EntityTypes.ARMOR_STAND, ArmorStandMeta.class, ArmorStandMeta::new);
        this.put(EntityTypes.ARROW, ArrowMeta.class, ArrowMeta::new);
        this.put(EntityTypes.AXOLOTL, AxolotlMeta.class, AxolotlMeta::new);
        this.put(EntityTypes.BAT, BatMeta.class, BatMeta::new);
        this.put(EntityTypes.BEE, BeeMeta.class, BeeMeta::new);
        this.put(EntityTypes.BLAZE, BlazeMeta.class, BlazeMeta::new);
        this.put(EntityTypes.BLOCK_DISPLAY, BlockDisplayMeta.class, BlockDisplayMeta::new);
        this.put(EntityTypes.BOAT, BoatMeta.class, BoatMeta::new);
        this.put(EntityTypes.BOGGED, BoggedMeta.class, BoggedMeta::new);
        this.put(EntityTypes.BREEZE, BreezeMeta.class, BreezeMeta::new);
        this.put(EntityTypes.BREEZE_WIND_CHARGE, SmallFireballMeta.class, SmallFireballMeta::new);
        this.put(EntityTypes.CAMEL, CamelMeta.class, CamelMeta::new);
        this.put(EntityTypes.CAT, CatMeta.class, CatMeta::new);
        this.put(EntityTypes.CAVE_SPIDER, CaveSpiderMeta.class, CaveSpiderMeta::new);
        this.put(EntityTypes.CHEST_MINECART, ChestMinecartMeta.class, ChestMinecartMeta::new);
        this.put(EntityTypes.CHICKEN, ChickenMeta.class, ChickenMeta::new);
        this.put(EntityTypes.COD, CodMeta.class, CodMeta::new);
        this.put(EntityTypes.COMMAND_BLOCK_MINECART, CommandBlockMinecartMeta.class, CommandBlockMinecartMeta::new);
        this.put(EntityTypes.COW, CowMeta.class, CowMeta::new);
        this.put(EntityTypes.CREAKING, LivingEntityMeta.class, LivingEntityMeta::new);
        this.put(EntityTypes.CREEPER, CreeperMeta.class, CreeperMeta::new);
        this.put(EntityTypes.DOLPHIN, DolphinMeta.class, DolphinMeta::new);
        this.put(EntityTypes.DONKEY, DonkeyMeta.class, DonkeyMeta::new);
        this.put(EntityTypes.DRAGON_FIREBALL, DragonFireballMeta.class, DragonFireballMeta::new);
        this.put(EntityTypes.DROWNED, DrownedMeta.class, DrownedMeta::new);
        this.put(EntityTypes.EGG, ThrownEggMeta.class, ThrownEggMeta::new);
        this.put(EntityTypes.ELDER_GUARDIAN, ElderGuardianMeta.class, ElderGuardianMeta::new);
        this.put(EntityTypes.END_CRYSTAL, EndCrystalMeta.class, EndCrystalMeta::new);
        this.put(EntityTypes.ENDER_DRAGON, EnderDragonMeta.class, EnderDragonMeta::new);
        this.put(EntityTypes.ENDER_PEARL, ThrownEnderPearlMeta.class, ThrownEnderPearlMeta::new);
        this.put(EntityTypes.ENDERMAN, EndermanMeta.class, EndermanMeta::new);
        this.put(EntityTypes.ENDERMITE, EndermiteMeta.class, EndermiteMeta::new);
        this.put(EntityTypes.EVOKER, EvokerMeta.class, EvokerMeta::new);
        this.put(EntityTypes.EVOKER_FANGS, EvokerFangsMeta.class, EvokerFangsMeta::new);
        this.put(EntityTypes.EYE_OF_ENDER, EyeOfEnderMeta.class, EyeOfEnderMeta::new);
        this.put(EntityTypes.FALLING_BLOCK, FallingBlockMeta.class, FallingBlockMeta::new);
        this.put(EntityTypes.FIREBALL, LargeFireballMeta.class, LargeFireballMeta::new);
        this.put(EntityTypes.FIREWORK_ROCKET, FireworkRocketMeta.class, FireworkRocketMeta::new);
        this.put(EntityTypes.FISHING_BOBBER, FishingHookMeta.class, FishingHookMeta::new);
        this.put(EntityTypes.FOX, FoxMeta.class, FoxMeta::new);
        this.put(EntityTypes.FROG, FrogMeta.class, FrogMeta::new);
        this.put(EntityTypes.FURNACE_MINECART, FurnaceMinecartMeta.class, FurnaceMinecartMeta::new);
        this.put(EntityTypes.GHAST, GhastMeta.class, GhastMeta::new);
        this.put(EntityTypes.GIANT, GiantMeta.class, GiantMeta::new);
        this.put(EntityTypes.GLOW_ITEM_FRAME, GlowItemFrameMeta.class, GlowItemFrameMeta::new);
        this.put(EntityTypes.GLOW_SQUID, GlowSquidMeta.class, GlowSquidMeta::new);
        this.put(EntityTypes.GOAT, GoatMeta.class, GoatMeta::new);
        this.put(EntityTypes.GUARDIAN, GuardianMeta.class, GuardianMeta::new);
        this.put(EntityTypes.HAPPY_GHAST, GhastMeta.class, GhastMeta::new);
        this.put(EntityTypes.HOGLIN, HoglinMeta.class, HoglinMeta::new);
        this.put(EntityTypes.HOPPER_MINECART, FurnaceMinecartMeta.class, FurnaceMinecartMeta::new);
        this.put(EntityTypes.HORSE, HorseMeta.class, HorseMeta::new);
        this.put(EntityTypes.HUSK, HuskMeta.class, HuskMeta::new);
        this.put(EntityTypes.ILLUSIONER, IllusionerMeta.class, IllusionerMeta::new);
        this.put(EntityTypes.INTERACTION, InteractionMeta.class, InteractionMeta::new);
        this.put(EntityTypes.IRON_GOLEM, IronGolemMeta.class, IronGolemMeta::new);
        this.put(EntityTypes.ITEM, ItemEntityMeta.class, ItemEntityMeta::new);
        this.put(EntityTypes.ITEM_DISPLAY, ItemDisplayMeta.class, ItemDisplayMeta::new);
        this.put(EntityTypes.ITEM_FRAME, ItemFrameMeta.class, ItemFrameMeta::new);
        this.put(EntityTypes.LEASH_KNOT, LeashKnotMeta.class, LeashKnotMeta::new);
        this.put(EntityTypes.LIGHTNING_BOLT, LightningBoltMeta.class, LightningBoltMeta::new);
        this.put(EntityTypes.LLAMA, LlamaMeta.class, LlamaMeta::new);
        this.put(EntityTypes.LLAMA_SPIT, LlamaSpitMeta.class, LlamaSpitMeta::new);
        this.put(EntityTypes.MAGMA_CUBE, MagmaCubeMeta.class, MagmaCubeMeta::new);
        this.put(EntityTypes.MARKER, MarkerMeta.class, MarkerMeta::new);
        this.put(EntityTypes.MOOSHROOM, MooshroomMeta.class, MooshroomMeta::new);
        this.put(EntityTypes.MULE, MuleMeta.class, MuleMeta::new);
        this.put(EntityTypes.OCELOT, OcelotMeta.class, OcelotMeta::new);
        this.put(EntityTypes.PAINTING, PaintingMeta.class, PaintingMeta::new);
        this.put(EntityTypes.PANDA, PandaMeta.class, PandaMeta::new);
        this.put(EntityTypes.PARROT, ParrotMeta.class, ParrotMeta::new);
        this.put(EntityTypes.PHANTOM, PhantomMeta.class, PhantomMeta::new);
        this.put(EntityTypes.PIG, PigMeta.class, PigMeta::new);
        this.put(EntityTypes.PIGLIN, PiglinMeta.class, PiglinMeta::new);
        this.put(EntityTypes.PIGLIN_BRUTE, PiglinBruteMeta.class, PiglinBruteMeta::new);
        this.put(EntityTypes.PILLAGER, PillagerMeta.class, PillagerMeta::new);
        this.put(EntityTypes.PLAYER, PlayerMeta.class, PlayerMeta::new);
        this.put(EntityTypes.POLAR_BEAR, PolarBearMeta.class, PolarBearMeta::new);
        this.put(EntityTypes.POTION, ThrownPotionMeta.class, ThrownPotionMeta::new);
        this.put(EntityTypes.PRIMED_TNT, PrimedTntMeta.class, PrimedTntMeta::new);
        this.put(EntityTypes.PUFFERFISH, PufferFishMeta.class, PufferFishMeta::new);
        this.put(EntityTypes.RABBIT, RabbitMeta.class, RabbitMeta::new);
        this.put(EntityTypes.RAVAGER, RavagerMeta.class, RavagerMeta::new);
        this.put(EntityTypes.SALMON, SalmonMeta.class, SalmonMeta::new);
        this.put(EntityTypes.SHEEP, SheepMeta.class, SheepMeta::new);
        this.put(EntityTypes.SHULKER, ShulkerMeta.class, ShulkerMeta::new);
        this.put(EntityTypes.SHULKER_BULLET, ShulkerBulletMeta.class, ShulkerBulletMeta::new);
        this.put(EntityTypes.SILVERFISH, SilverfishMeta.class, SilverfishMeta::new);
        this.put(EntityTypes.SKELETON, SkeletonMeta.class, SkeletonMeta::new);
        this.put(EntityTypes.SKELETON_HORSE, SkeletonHorseMeta.class, SkeletonHorseMeta::new);
        this.put(EntityTypes.SLIME, SlimeMeta.class, SlimeMeta::new);
        this.put(EntityTypes.SMALL_FIREBALL, SmallFireballMeta.class, SmallFireballMeta::new);
        this.put(EntityTypes.SNIFFER, SnifferMeta.class, SnifferMeta::new);
        this.put(EntityTypes.SNOW_GOLEM, SnowGolemMeta.class, SnowGolemMeta::new);
        this.put(EntityTypes.SNOWBALL, SnowballMeta.class, SnowballMeta::new);
        this.put(EntityTypes.SPAWNER_MINECART, SpawnerMinecartMeta.class, SpawnerMinecartMeta::new);
        this.put(EntityTypes.SPIDER, SpiderMeta.class, SpiderMeta::new);
        this.put(EntityTypes.SQUID, SquidMeta.class, SquidMeta::new);
        this.put(EntityTypes.STRAY, StrayMeta.class, StrayMeta::new);
        this.put(EntityTypes.STRIDER, StriderMeta.class, StriderMeta::new);
        this.put(EntityTypes.TADPOLE, LivingEntityMeta.class, LivingEntityMeta::new);
        this.put(EntityTypes.TEXT_DISPLAY, TextDisplayMeta.class, TextDisplayMeta::new);
        this.put(EntityTypes.THROWN_EXP_BOTTLE, ThrownExpBottleMeta.class, ThrownExpBottleMeta::new);
        this.put(EntityTypes.TNT, TntMeta.class, TntMeta::new);
        this.put(EntityTypes.TNT_MINECART, TntMinecartMeta.class, TntMinecartMeta::new);
        this.put(EntityTypes.TRADER_LLAMA, TraderLlamaMeta.class, TraderLlamaMeta::new);
        this.put(EntityTypes.TRIDENT, ThrownTridentMeta.class, ThrownTridentMeta::new);
        this.put(EntityTypes.TROPICAL_FISH, TropicalFishMeta.class, TropicalFishMeta::new);
        this.put(EntityTypes.TURTLE, TurtleMeta.class, TurtleMeta::new);
        this.put(EntityTypes.VEX, VexMeta.class, VexMeta::new);
        this.put(EntityTypes.VILLAGER, VillagerMeta.class, VillagerMeta::new);
        this.put(EntityTypes.VINDICATOR, VindicatorMeta.class, VindicatorMeta::new);
        this.put(EntityTypes.WANDERING_TRADER, WanderingTraderMeta.class, WanderingTraderMeta::new);
        this.put(EntityTypes.WARDEN, WardenMeta.class, WardenMeta::new);
        this.put(EntityTypes.WIND_CHARGE, SmallFireballMeta.class, SmallFireballMeta::new);
        this.put(EntityTypes.WITCH, WitchMeta.class, WitchMeta::new);
        this.put(EntityTypes.WITHER, WitherMeta.class, WitherMeta::new);
        this.put(EntityTypes.WITHER_SKELETON, WitherSkeletonMeta.class, WitherSkeletonMeta::new);
        this.put(EntityTypes.WITHER_SKULL, WitherSkullMeta.class, WitherSkullMeta::new);
        this.put(EntityTypes.WOLF, WolfMeta.class, WolfMeta::new);
        this.put(EntityTypes.ZOGLIN, ZoglinMeta.class, ZoglinMeta::new);
        this.put(EntityTypes.ZOMBIE, ZombieMeta.class, ZombieMeta::new);
        this.put(EntityTypes.ZOMBIE_HORSE, ZombieHorseMeta.class, ZombieHorseMeta::new);
        this.put(EntityTypes.ZOMBIE_VILLAGER, ZombieVillagerMeta.class, ZombieVillagerMeta::new);
        this.put(EntityTypes.ZOMBIFIED_PIGLIN, ZombifiedPiglinMeta.class, ZombifiedPiglinMeta::new);
    }

    private void put(EntityType entityType, Class<? extends EntityMeta> metaClass, BiFunction<Integer, Metadata, EntityMeta> function) {
        this.converters.put(entityType, function);
        this.metaClasses.put(entityType, metaClass);
    }

    public Class<? extends EntityMeta> getMetaClass(EntityType entityType) {
        return this.metaClasses.getOrDefault(entityType, EntityMeta.class);
    }

    @NotNull
    public BiFunction<Integer, Metadata, EntityMeta> get(EntityType entityType) {
        return this.converters.getOrDefault(entityType, EntityMeta::new);
    }
}

