/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.display;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.display.AbstractDisplayMeta;
import net.kyori.adventure.text.Component;

public class TextDisplayMeta
extends AbstractDisplayMeta {
    public static final byte OFFSET = AbstractDisplayMeta.MAX_OFFSET;
    public static final byte MAX_OFFSET = TextDisplayMeta.offset(OFFSET, 5);
    private static final byte SHADOW = 1;
    private static final byte SEE_THROUGH = 2;
    private static final byte USE_DEFAULT_BACKGROUND = 4;
    private static final byte ALIGN_LEFT = 8;
    private static final byte ALIGN_RIGHT = 16;

    public TextDisplayMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    public Component getText() {
        return (Component)this.metadata.getIndex(OFFSET, Component.empty());
    }

    public void setText(Component component) {
        this.metadata.setIndex(OFFSET, EntityDataTypes.ADV_COMPONENT, component);
    }

    public int getLineWidth() {
        return this.metadata.getIndex(TextDisplayMeta.offset(OFFSET, 1), 200);
    }

    public void setLineWidth(int value) {
        this.metadata.setIndex(TextDisplayMeta.offset(OFFSET, 1), EntityDataTypes.INT, value);
    }

    public int getBackgroundColor() {
        return this.metadata.getIndex(TextDisplayMeta.offset(OFFSET, 2), 0);
    }

    public void setBackgroundColor(int value) {
        this.metadata.setIndex(TextDisplayMeta.offset(OFFSET, 2), EntityDataTypes.INT, value);
    }

    public byte getTextOpacity() {
        return this.metadata.getIndex(TextDisplayMeta.offset(OFFSET, 3), (byte)-1);
    }

    public void setTextOpacity(byte value) {
        this.metadata.setIndex(TextDisplayMeta.offset(OFFSET, 3), EntityDataTypes.BYTE, value);
    }

    public boolean isShadow() {
        return this.getMaskBit(TextDisplayMeta.offset(OFFSET, 4), (byte)1);
    }

    public void setShadow(boolean value) {
        this.setMaskBit(TextDisplayMeta.offset(OFFSET, 4), (byte)1, value);
    }

    public boolean isSeeThrough() {
        return this.getMaskBit(TextDisplayMeta.offset(OFFSET, 4), (byte)2);
    }

    public void setSeeThrough(boolean value) {
        this.setMaskBit(TextDisplayMeta.offset(OFFSET, 4), (byte)2, value);
    }

    public boolean isUseDefaultBackground() {
        return this.getMaskBit(TextDisplayMeta.offset(OFFSET, 4), (byte)4);
    }

    public void setUseDefaultBackground(boolean value) {
        this.setMaskBit(TextDisplayMeta.offset(OFFSET, 4), (byte)4, value);
    }

    public boolean isAlignLeft() {
        return this.getMaskBit(TextDisplayMeta.offset(OFFSET, 4), (byte)8);
    }

    public void setAlignLeft(boolean value) {
        this.setMaskBit(OFFSET + 4, (byte)8, value);
    }

    public boolean isAlignRight() {
        return this.getMaskBit(TextDisplayMeta.offset(OFFSET, 4), (byte)16);
    }

    public void setAlignRight(boolean value) {
        this.setMaskBit(TextDisplayMeta.offset(OFFSET, 4), (byte)16, value);
    }
}

