/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.mobs;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import java.util.Optional;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.types.AgeableMeta;
import org.jetbrains.annotations.NotNull;

public class FrogMeta
extends AgeableMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 19;

    public FrogMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    @NotNull
    public Variant getVariant() {
        return this.metadata.getIndex((byte)17, Variant.TEMPERATE);
    }

    public void setVariant(@NotNull Variant value) {
        this.metadata.setIndex((byte)17, EntityDataTypes.FROG_VARIANT, value.ordinal());
    }

    public Optional<Integer> getTongueTarget() {
        return this.metadata.getIndex(FrogMeta.offset((byte)17, 1), Optional.empty());
    }

    public void setTongueTarget(int value) {
        this.metadata.setIndex(FrogMeta.offset((byte)17, 1), EntityDataTypes.OPTIONAL_INT, Optional.of(value));
    }

    public static enum Variant {
        TEMPERATE,
        WARM,
        COLD;

        private static final Variant[] VALUES;

        static {
            VALUES = Variant.values();
        }
    }
}

