/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.mobs.golem;

import com.github.retrooper.packetevents.protocol.color.DyeColor;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.world.Direction;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.types.MobMeta;

public class ShulkerMeta
extends MobMeta {
    public static final byte OFFSET = 16;
    public static final byte MAX_OFFSET = 17;
    private static final DyeColor[] DYE_COLORS = DyeColor.values();

    public ShulkerMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    public Direction getAttachFace() {
        return this.metadata.getIndex((byte)16, Direction.DOWN);
    }

    public void setAttachFace(Direction value) {
        this.metadata.setIndex((byte)16, EntityDataTypes.INT, value.ordinal());
    }

    public byte getShieldHeight() {
        return this.metadata.getIndex(ShulkerMeta.offset((byte)16, 1), (byte)0);
    }

    public void setShieldHeight(byte value) {
        this.metadata.setIndex(ShulkerMeta.offset((byte)16, 1), EntityDataTypes.BYTE, value);
    }

    public byte getColor() {
        return this.metadata.getIndex(ShulkerMeta.offset((byte)16, 2), (byte)16);
    }

    public DyeColor getColorEnum() {
        return DYE_COLORS[this.getColor()];
    }

    public void setColor(byte value) {
        this.metadata.setIndex(ShulkerMeta.offset((byte)16, 2), EntityDataTypes.BYTE, value);
    }

    public void setColor(DyeColor color) {
        this.setColor((byte)color.ordinal());
    }
}

