/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.mobs.horse;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.mobs.horse.BaseHorseMeta;
import org.jetbrains.annotations.NotNull;

public class HorseMeta
extends BaseHorseMeta {
    public static final byte OFFSET = 18;
    public static final byte MAX_OFFSET = 19;

    public HorseMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    public Variant getVariant() {
        return HorseMeta.getVariantFromID(this.metadata.getIndex((byte)18, 0));
    }

    public void setVariant(Variant variant) {
        this.metadata.setIndex((byte)18, EntityDataTypes.INT, HorseMeta.getVariantID(variant.marking, variant.color));
    }

    public static int getVariantID(@NotNull Marking marking, @NotNull Color color) {
        return (marking.ordinal() << 8) + color.ordinal();
    }

    public static Variant getVariantFromID(int variantID) {
        return new Variant(Marking.VALUES[variantID >> 8], Color.VALUES[variantID & 0xFF]);
    }

    public static class Variant {
        private Marking marking;
        private Color color;

        public Variant(@NotNull Marking marking, @NotNull Color color) {
            this.marking = marking;
            this.color = color;
        }

        @NotNull
        public Marking getMarking() {
            return this.marking;
        }

        public void setMarking(@NotNull Marking marking) {
            this.marking = marking;
        }

        @NotNull
        public Color getColor() {
            return this.color;
        }

        public void setColor(@NotNull Color color) {
            this.color = color;
        }
    }

    public static enum Marking {
        NONE,
        WHITE,
        WHITE_FIELD,
        WHITE_DOTS,
        BLACK_DOTS;

        private static final Marking[] VALUES;

        static {
            VALUES = Marking.values();
        }
    }

    public static enum Color {
        WHITE,
        CREAMY,
        CHESTNUT,
        BROWN,
        BLACK,
        GRAY,
        DARK_BROWN;

        private static final Color[] VALUES;

        static {
            VALUES = Color.values();
        }
    }
}

