/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.mobs.monster;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.types.MobMeta;
import org.jetbrains.annotations.NotNull;

public class CreeperMeta
extends MobMeta {
    public static final byte OFFSET = 16;
    public static final byte MAX_OFFSET = 19;

    public CreeperMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    @NotNull
    public State getState() {
        int id = this.metadata.getIndex((byte)16, -1);
        return id == -1 ? State.IDLE : State.FUSE;
    }

    public void setState(@NotNull State value) {
        this.metadata.setIndex((byte)16, EntityDataTypes.INT, value == State.IDLE ? -1 : 1);
    }

    public boolean isCharged() {
        return this.metadata.getIndex(CreeperMeta.offset((byte)16, 1), false);
    }

    public void setCharged(boolean value) {
        this.metadata.setIndex(CreeperMeta.offset((byte)16, 1), EntityDataTypes.BOOLEAN, value);
    }

    public boolean isIgnited() {
        return this.metadata.getIndex(CreeperMeta.offset((byte)16, 2), false);
    }

    public void setIgnited(boolean value) {
        this.metadata.setIndex(CreeperMeta.offset((byte)16, 2), EntityDataTypes.BOOLEAN, value);
    }

    public static enum State {
        IDLE,
        FUSE;

    }
}

