/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.mobs.tameable;

import com.github.retrooper.packetevents.protocol.entity.cat.CatVariant;
import com.github.retrooper.packetevents.protocol.entity.cat.CatVariants;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import me.tofaa.entitylib.extras.DyeColor;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.types.TameableMeta;
import org.jetbrains.annotations.NotNull;

public class CatMeta
extends TameableMeta {
    public static final byte OFFSET = 19;
    public static final byte MAX_OFFSET = 23;
    private static final DyeColor[] COLORS = DyeColor.values();

    public CatMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    @NotNull
    public Variant getVariant() {
        CatVariant catVariant = this.metadata.getIndex((byte)19, CatVariants.BLACK);
        return Variant.fromCatVariant(catVariant);
    }

    public void setVariant(@NotNull Variant value) {
        this.metadata.setIndex((byte)19, EntityDataTypes.TYPED_CAT_VARIANT, value.getCatVariant());
    }

    public boolean isLying() {
        return this.metadata.getIndex(CatMeta.offset((byte)19, 1), false);
    }

    public void setLying(boolean value) {
        this.metadata.setIndex(CatMeta.offset((byte)19, 1), EntityDataTypes.BOOLEAN, value);
    }

    public boolean isRelaxed() {
        return this.metadata.getIndex(CatMeta.offset((byte)19, 2), false);
    }

    public void setRelaxed(boolean value) {
        this.metadata.setIndex(CatMeta.offset((byte)19, 2), EntityDataTypes.BOOLEAN, value);
    }

    @NotNull
    public DyeColor getCollarColor() {
        return COLORS[this.metadata.getIndex(CatMeta.offset((byte)19, 3), DyeColor.RED.ordinal())];
    }

    public void setCollarColor(@NotNull DyeColor value) {
        this.metadata.setIndex(CatMeta.offset((byte)19, 3), EntityDataTypes.INT, value.ordinal());
    }

    public static enum Variant {
        ALL_BLACK(CatVariants.ALL_BLACK),
        BLACK(CatVariants.BLACK),
        BRITISH_SHORTHAIR(CatVariants.BRITISH_SHORTHAIR),
        CALICO(CatVariants.CALICO),
        JELLIE(CatVariants.JELLIE),
        PERSIAN(CatVariants.PERSIAN),
        RAGDOLL(CatVariants.RAGDOLL),
        RED(CatVariants.RED),
        SIAMESE(CatVariants.SIAMESE),
        TABBY(CatVariants.TABBY),
        WHITE(CatVariants.WHITE);

        private final CatVariant catVariant;
        private static final Variant[] VALUES;

        private Variant(CatVariant catVariant) {
            this.catVariant = catVariant;
        }

        public CatVariant getCatVariant() {
            return this.catVariant;
        }

        @NotNull
        public static Variant fromCatVariant(@NotNull CatVariant catVariant) {
            for (Variant variant : VALUES) {
                if (!variant.getCatVariant().equals((Object)catVariant)) continue;
                return variant;
            }
            return BLACK;
        }

        static {
            VALUES = Variant.values();
        }
    }
}

