/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.mobs.tameable;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfVariant;
import com.github.retrooper.packetevents.protocol.entity.wolfvariant.WolfVariants;
import me.tofaa.entitylib.extras.DyeColor;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.types.TameableMeta;
import org.jetbrains.annotations.NotNull;

public class WolfMeta
extends TameableMeta {
    public static final byte OFFSET = 19;
    public static final byte MAX_OFFSET = 24;

    public WolfMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    @NotNull
    public WolfVariant getVariant() {
        return this.metadata.getIndex(WolfMeta.offset((byte)19, 3), WolfVariants.PALE);
    }

    public void setVariant(@NotNull WolfVariant value) {
        this.metadata.setIndex(WolfMeta.offset((byte)19, 3), EntityDataTypes.TYPED_WOLF_VARIANT, value);
    }

    public boolean isBegging() {
        return this.metadata.getIndex((byte)19, false);
    }

    public void setBegging(boolean value) {
        this.metadata.setIndex((byte)19, EntityDataTypes.BOOLEAN, value);
    }

    public int getCollarColor() {
        return this.metadata.getIndex(WolfMeta.offset((byte)19, 1), 14);
    }

    public void setCollarColor(int value) {
        this.metadata.setIndex(WolfMeta.offset((byte)19, 1), EntityDataTypes.INT, value);
    }

    public DyeColor getCollarColorAsDye() {
        return DyeColor.values()[this.metadata.getIndex(WolfMeta.offset((byte)19, 1), DyeColor.RED.ordinal())];
    }

    public void setCollarColor(DyeColor color) {
        this.metadata.setIndex(WolfMeta.offset((byte)19, 1), EntityDataTypes.INT, color.ordinal());
    }

    public int getAngerTime() {
        return this.metadata.getIndex(WolfMeta.offset((byte)19, 2), 0);
    }

    public void setAngerTime(int value) {
        this.metadata.setIndex(WolfMeta.offset((byte)19, 2), EntityDataTypes.INT, value);
    }
}

