/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.mobs.water;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.mobs.water.BaseFishMeta;
import me.tofaa.entitylib.meta.types.ObjectData;
import org.jetbrains.annotations.NotNull;

public class TropicalFishMeta
extends BaseFishMeta
implements ObjectData {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 18;

    public TropicalFishMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    public Variant getVariant() {
        return TropicalFishMeta.getVariantFromID(this.metadata.getIndex((byte)17, 0));
    }

    public void setVariant(Variant variant) {
        this.metadata.setIndex((byte)17, EntityDataTypes.INT, TropicalFishMeta.getVariantID(variant));
    }

    public static int getVariantID(Variant variant) {
        int id = 0;
        id |= variant.patternColor;
        id <<= 8;
        id |= variant.bodyColor;
        id <<= 8;
        id |= variant.pattern.ordinal();
        id <<= 8;
        return id |= variant.type.ordinal();
    }

    public static Variant getVariantFromID(int variantID) {
        Type type = Type.VALUES[variantID & 0xFF];
        Pattern pattern = Pattern.VALUES[(variantID >>= 8) & 0xFF];
        byte bodyColor = (byte)((variantID >>= 8) & 0xFF);
        byte patternColor = (byte)((variantID >>= 8) & 0xFF);
        return new Variant(type, pattern, bodyColor, patternColor);
    }

    @Override
    public int getObjectData() {
        return 0;
    }

    @Override
    public boolean requiresVelocityPacketAtSpawn() {
        return false;
    }

    public static class Variant {
        private Type type;
        private Pattern pattern;
        private byte bodyColor;
        private byte patternColor;

        public Variant(@NotNull Type type, @NotNull Pattern pattern, byte bodyColor, byte patternColor) {
            this.type = type;
            this.pattern = pattern;
            this.bodyColor = bodyColor;
            this.patternColor = patternColor;
        }

        @NotNull
        public Type getType() {
            return this.type;
        }

        public void setType(@NotNull Type type) {
            this.type = type;
        }

        @NotNull
        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(@NotNull Pattern pattern) {
            this.pattern = pattern;
        }

        public byte getBodyColor() {
            return this.bodyColor;
        }

        public void setBodyColor(byte bodyColor) {
            this.bodyColor = bodyColor;
        }

        public byte getPatternColor() {
            return this.patternColor;
        }

        public void setPatternColor(byte patternColor) {
            this.patternColor = patternColor;
        }
    }

    public static enum Pattern {
        KOB,
        SUNSTREAK,
        SNOOPER,
        DASHER,
        BRINELY,
        SPOTTY,
        NONE;

        private static final Pattern[] VALUES;

        static {
            VALUES = Pattern.values();
        }
    }

    public static enum Type {
        SMALL,
        LARGE,
        INVISIBLE;

        private static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

