/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.other;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.util.Vector3i;
import me.tofaa.entitylib.meta.EntityMeta;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.types.ObjectData;

public class FallingBlockMeta
extends EntityMeta
implements ObjectData {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = 9;
    private int blockStateId;

    public FallingBlockMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    public Vector3i getSpawnPosition() {
        return this.metadata.getIndex((byte)8, Vector3i.zero());
    }

    public void setSpawnPosition(Vector3i value) {
        this.metadata.setIndex((byte)8, EntityDataTypes.BLOCK_POSITION, value);
    }

    public int getBlockStateId() {
        return this.blockStateId;
    }

    public void setBlockStateId(int blockStateId) {
        this.blockStateId = blockStateId;
    }

    public WrappedBlockState getBlockState() {
        return WrappedBlockState.getByGlobalId((ClientVersion)PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), (int)this.getBlockStateId());
    }

    public void setBlockState(WrappedBlockState blockState) {
        this.setBlockStateId(blockState.getGlobalId());
    }

    @Override
    public int getObjectData() {
        return this.blockStateId;
    }

    @Override
    public boolean requiresVelocityPacketAtSpawn() {
        return false;
    }
}

