/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.other;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import me.tofaa.entitylib.extras.Rotation;
import me.tofaa.entitylib.meta.EntityMeta;
import me.tofaa.entitylib.meta.Metadata;
import me.tofaa.entitylib.meta.types.ObjectData;
import org.jetbrains.annotations.NotNull;

public class ItemFrameMeta
extends EntityMeta
implements ObjectData {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = 10;
    private Orientation orientation = Orientation.DOWN;

    public ItemFrameMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    @NotNull
    public ItemStack getItem() {
        return this.metadata.getIndex((byte)9, ItemStack.EMPTY);
    }

    public void setItem(@NotNull ItemStack value) {
        this.metadata.setIndex((byte)9, EntityDataTypes.ITEMSTACK, value);
    }

    @NotNull
    public Rotation getRotation() {
        return Rotation.values()[this.metadata.getIndex(ItemFrameMeta.offset((byte)8, 1), 0)];
    }

    public void setRotation(@NotNull Rotation value) {
        this.metadata.setIndex(ItemFrameMeta.offset((byte)8, 1), EntityDataTypes.INT, value.ordinal());
    }

    @NotNull
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(@NotNull Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public int getObjectData() {
        return this.orientation.ordinal();
    }

    @Override
    public boolean requiresVelocityPacketAtSpawn() {
        return false;
    }

    public static enum Orientation {
        DOWN,
        UP,
        NORTH,
        SOUTH,
        WEST,
        EAST;

    }
}

