/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.other;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import me.tofaa.entitylib.meta.EntityMeta;
import me.tofaa.entitylib.meta.Metadata;

public class TntMeta
extends EntityMeta {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = 10;

    public TntMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    public int getFuseTime() {
        return this.metadata.getIndex((byte)8, 80);
    }

    public void setFuseTime(int value) {
        this.metadata.setIndex((byte)8, EntityDataTypes.INT, value);
    }

    public int getBlockData() {
        return this.metadata.getIndex(TntMeta.offset((byte)8, 1), StateTypes.TNT.createBlockState().getGlobalId());
    }

    public void setBlockData(int blockData) {
        this.metadata.setIndex(TntMeta.offset((byte)8, 1), EntityDataTypes.BLOCK_STATE, blockData);
    }

    public WrappedBlockState getBlockState() {
        return WrappedBlockState.getByGlobalId((ClientVersion)PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), (int)this.getBlockData());
    }

    public void setBlockState(WrappedBlockState blockState) {
        this.setBlockData(blockState.getGlobalId());
    }
}

