/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.meta.types;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.player.HumanoidArm;
import com.github.retrooper.packetevents.util.Vector3i;
import java.util.Optional;
import me.tofaa.entitylib.meta.EntityMeta;
import me.tofaa.entitylib.meta.Metadata;

public class LivingEntityMeta
extends EntityMeta {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = 15;
    private static final byte IS_HAND_ACTIVE_BIT = 1;
    private static final byte ACTIVE_HAND_BIT = 2;
    private static final byte IS_IN_SPIN_ATTACK_BIT = 4;

    public LivingEntityMeta(int entityId, Metadata metadata) {
        super(entityId, metadata);
    }

    public float getHealth() {
        return this.metadata.getIndex(LivingEntityMeta.offset((byte)8, 1), Float.valueOf(1.0f)).floatValue();
    }

    public int getPotionEffectColor() {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_9);
        return this.metadata.getIndex(LivingEntityMeta.offset((byte)8, 2), 0);
    }

    public void setPotionEffectColor(int value) {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_9);
        this.metadata.setIndex(LivingEntityMeta.offset((byte)8, 2), EntityDataTypes.INT, value);
    }

    public void setPotionEffectColor(int red, int green, int blue) {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_9);
        this.setPotionEffectColor(red << 16 + green << 8 + blue);
    }

    public boolean isPotionEffectAmbient() {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_9);
        return this.metadata.getIndex(LivingEntityMeta.offset((byte)8, 3), false);
    }

    public void setPotionEffectAmbient(boolean value) {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_9);
        this.metadata.setIndex(LivingEntityMeta.offset((byte)8, 3), EntityDataTypes.BOOLEAN, value);
    }

    public int getArrowCount() {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_9);
        return this.metadata.getIndex(LivingEntityMeta.offset((byte)8, 4), 0);
    }

    public void setArrowCount(int value) {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_9);
        this.metadata.setIndex(LivingEntityMeta.offset((byte)8, 4), EntityDataTypes.INT, value);
    }

    public void setHealth(float value) {
        this.metadata.setIndex(LivingEntityMeta.offset((byte)8, 1), EntityDataTypes.FLOAT, Float.valueOf(value));
    }

    public HumanoidArm getActiveHand() {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_9);
        return this.getMaskBit((byte)8, (byte)2) ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    public void setActiveHand(HumanoidArm value) {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_9);
        this.setMaskBit(8, (byte)2, value == HumanoidArm.LEFT);
    }

    public boolean isInRiptideSpinAttack() {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_13);
        return this.getMaskBit((byte)8, (byte)4);
    }

    public void setInRiptideSpinAttack(boolean value) {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_13);
        this.setMaskBit(8, (byte)4, value);
    }

    public Optional<Vector3i> getBedPosition() {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_14);
        return this.metadata.getIndex(LivingEntityMeta.offset((byte)8, 6), Optional.empty());
    }

    public void setBedPosition(Vector3i value) {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_14);
        this.metadata.setIndex(LivingEntityMeta.offset((byte)8, 6), EntityDataTypes.OPTIONAL_BLOCK_POSITION, value == null ? Optional.empty() : Optional.of(value));
    }

    public int getBeeStingerCount() {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_15);
        return this.metadata.getIndex(LivingEntityMeta.offset((byte)8, 5), 0);
    }

    public void setBeeStingerCount(int value) {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_15);
        this.metadata.setIndex(LivingEntityMeta.offset((byte)8, 5), EntityDataTypes.INT, value);
    }

    public boolean isHandActive() {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_15);
        return this.getMaskBit((byte)8, (byte)1);
    }

    public void setHandActive(boolean value) {
        LivingEntityMeta.isVersionNewer(ServerVersion.V_1_15);
        this.setMaskBit(8, (byte)1, value);
    }
}

