/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.spigot;

import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import com.github.retrooper.packetevents.protocol.player.HumanoidArm;
import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.google.common.collect.Multimap;
import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.inventory.MainHand;
import org.jetbrains.annotations.Nullable;

public final class ExtraConversionUtil {
    private static Method PLAYER_PROFILE_METHOD;
    private static Class<?> PROFILE_CLASS;
    private static Method GET_PROPERTIES_METHOD;

    private ExtraConversionUtil() {
    }

    @Nullable
    public static UserProfile getProfileFromBukkitPlayer(Player player) {
        try {
            Multimap properties;
            Collection textures;
            Object profile = PLAYER_PROFILE_METHOD.invoke((Object)player, new Object[0]);
            if (PROFILE_CLASS == null) {
                PROFILE_CLASS = profile.getClass();
                GET_PROPERTIES_METHOD = PROFILE_CLASS.getMethod("getProperties", new Class[0]);
                GET_PROPERTIES_METHOD.setAccessible(true);
            }
            if ((textures = (properties = (Multimap)GET_PROPERTIES_METHOD.invoke(profile, new Object[0])).get((Object)"textures")) == null || textures.isEmpty()) {
                return new UserProfile(player.getUniqueId(), player.getName());
            }
            Object texture = textures.iterator().next();
            String value = (String)texture.getClass().getDeclaredMethod("value", new Class[0]).invoke(texture, new Object[0]);
            String signature = (String)texture.getClass().getDeclaredMethod("signature", new Class[0]).invoke(texture, new Object[0]);
            ArrayList<TextureProperty> t = new ArrayList<TextureProperty>();
            t.add(new TextureProperty("textures", value, signature));
            return new UserProfile(player.getUniqueId(), player.getName(), t);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static EntityPose fromBukkitPose(Pose pose) {
        return EntityPose.values()[pose.ordinal()];
    }

    public static HumanoidArm fromBukkitHand(MainHand hand) {
        if (hand == MainHand.RIGHT) {
            return HumanoidArm.RIGHT;
        }
        return HumanoidArm.LEFT;
    }

    static {
        try {
            PLAYER_PROFILE_METHOD = SpigotReflectionUtil.CRAFT_PLAYER_CLASS.getMethod("getProfile", new Class[0]);
            PLAYER_PROFILE_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

