/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.spigot;

import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import java.lang.reflect.Field;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.tofaa.entitylib.EntityIdProvider;
import me.tofaa.entitylib.Platform;
import org.bukkit.Bukkit;
import org.bukkit.UnsafeValues;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class SpigotEntityIdProvider
implements EntityIdProvider {
    private final Platform<JavaPlugin> platform;
    private final Supplier<Integer> entityIdSupplier;

    public SpigotEntityIdProvider(@NotNull Platform<JavaPlugin> platform) {
        this.platform = platform;
        this.entityIdSupplier = this.detectIdSupplier();
    }

    @Override
    public int provide(@NotNull UUID entityUUID, @NotNull EntityType entityType) {
        return this.entityIdSupplier.get();
    }

    private Supplier<Integer> detectIdSupplier() {
        ServerVersion serverVersion = this.platform.getAPI().getPacketEvents().getServerManager().getVersion();
        if (SpigotEntityIdProvider.isPaper() && serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            return () -> ((UnsafeValues)Bukkit.getUnsafe()).nextEntityId();
        }
        Class<?> entityClass = this.getEntityClass();
        if (serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            Field entityAtomicField = SpigotEntityIdProvider.getField(entityClass, "entityCount", "d", "c");
            if (entityAtomicField == null) {
                throw new IllegalStateException("Could not find entity counter field");
            }
            try {
                entityAtomicField.setAccessible(true);
                AtomicInteger counter = (AtomicInteger)entityAtomicField.get(null);
                return counter::incrementAndGet;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to access entity counter", exception);
            }
        }
        Field entityLegacyField = SpigotEntityIdProvider.getField(entityClass, "entityCount");
        if (entityLegacyField == null) {
            throw new IllegalStateException("Could not find legacy entity counter field");
        }
        try {
            entityLegacyField.setAccessible(true);
            return () -> {
                try {
                    int entityId = entityLegacyField.getInt(null);
                    entityLegacyField.setInt(null, entityId + 1);
                    return entityId;
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Failed to modify entity counter", exception);
                }
            };
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to access legacy entity counter", exception);
        }
    }

    private Class<?> getEntityClass() {
        ServerVersion serverVersion = this.platform.getAPI().getPacketEvents().getServerManager().getVersion();
        boolean isFlattened = serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17);
        String version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        String packagePath = isFlattened ? "net.minecraft.world.entity" : "net.minecraft.server." + version;
        try {
            return Class.forName(packagePath + ".Entity");
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Could not find Entity class", exception);
        }
    }

    private static Field getField(Class<?> clazz, String ... possibleNames) {
        for (String name : possibleNames) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        return null;
    }

    private static boolean isPaper() {
        return Stream.of("com.destroystokyo.paper.PaperConfig", "io.papermc.paper.configuration.Configuration").anyMatch(SpigotEntityIdProvider::hasClass);
    }

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }
}

