/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.spigot;

import com.github.retrooper.packetevents.PacketEventsAPI;
import io.github.retrooper.packetevents.bstats.bukkit.Metrics;
import io.github.retrooper.packetevents.bstats.charts.CustomChart;
import io.github.retrooper.packetevents.bstats.charts.SimplePie;
import java.util.logging.Logger;
import me.tofaa.entitylib.APIConfig;
import me.tofaa.entitylib.EntityLib;
import me.tofaa.entitylib.UserLocaleProvider;
import me.tofaa.entitylib.common.AbstractPlatform;
import me.tofaa.entitylib.spigot.SpigotEntityIdProvider;
import me.tofaa.entitylib.spigot.SpigotEntityLibAPI;
import me.tofaa.entitylib.spigot.SpigotPlayerLocaleProvider;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SpigotEntityLibPlatform
extends AbstractPlatform<JavaPlugin> {
    private SpigotEntityLibAPI api;
    private UserLocaleProvider userLocaleProvider = new SpigotPlayerLocaleProvider();

    public SpigotEntityLibPlatform(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    public void setupApi(@NotNull APIConfig settings) {
        super.setupApi(settings);
        this.logger = settings.shouldUsePlatformLogger() ? ((JavaPlugin)this.handle).getLogger() : Logger.getLogger("EntityLib");
        this.api = new SpigotEntityLibAPI(this, settings);
        this.setEntityIdProvider(new SpigotEntityIdProvider(this));
        this.api.onLoad();
        this.api.onEnable();
        if (settings.shouldUseBstats()) {
            PacketEventsAPI<?> pe = this.api.getPacketEvents();
            Metrics metrics = new Metrics((Plugin)pe.getPlugin(), 21916);
            metrics.addCustomChart((CustomChart)new SimplePie("entitylib-version", () -> EntityLib.getVersion().toString()));
        }
    }

    public SpigotEntityLibAPI getAPI() {
        return this.api;
    }

    @Override
    public String getName() {
        return "Spigot";
    }

    @Override
    @NotNull
    public UserLocaleProvider getUserLocaleProvider() {
        return this.userLocaleProvider;
    }

    @Override
    public void setUserLocaleProvider(@NotNull UserLocaleProvider provider) {
        this.userLocaleProvider = provider;
    }
}

