/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.spigot;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Function;
import me.tofaa.entitylib.UserLocaleProvider;
import net.kyori.adventure.translation.Translator;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SpigotPlayerLocaleProvider
implements UserLocaleProvider {
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static final Function<Player, Locale> provider = SpigotPlayerLocaleProvider.get();

    @Override
    public Locale locale(UUID user) {
        Player player = Bukkit.getPlayer((UUID)user);
        return player == null ? DEFAULT_LOCALE : provider.apply(player);
    }

    @NotNull
    private static Function<Player, Locale> get() {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        try {
            MethodHandle adventureMethod = lookup.findVirtual(Player.class, "locale", MethodType.methodType(Locale.class));
            return player -> {
                try {
                    return adventureMethod.invokeExact((Player)player);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (IllegalAccessException | NoSuchMethodException adventureMethod) {
            MethodType methodType = MethodType.methodType(String.class);
            try {
                MethodHandle legacySpigotMethod = lookup.findVirtual(Player.Spigot.class, "getLocale", methodType);
                return player -> {
                    try {
                        Locale locale = Translator.parseLocale((String)legacySpigotMethod.invokeExact(player.spigot()));
                        return locale == null ? DEFAULT_LOCALE : locale;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (IllegalAccessException | NoSuchMethodException legacySpigotMethod) {
                try {
                    MethodHandle legacyMethod = lookup.findVirtual(Player.class, "getLocale", methodType);
                    return player -> {
                        try {
                            Locale locale = Translator.parseLocale((String)legacyMethod.invokeExact((Player)player));
                            return locale == null ? DEFAULT_LOCALE : locale;
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    };
                }
                catch (IllegalAccessException | NoSuchMethodException ignored) {
                    throw new RuntimeException("No way to get players locale found");
                }
            }
        }
    }
}

