/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.tick;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import me.tofaa.entitylib.tick.Tickable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class TickContainer<T extends Tickable, H> {
    private final Set<T> tickables = new HashSet<T>();
    private H handle;

    @NotNull
    public Collection<T> getTickables() {
        return Collections.unmodifiableCollection(this.tickables);
    }

    public boolean addTickable(@NotNull T tickable) {
        return this.tickables.add(tickable);
    }

    public boolean removeTickable(T tickable) {
        return this.tickables.remove(tickable);
    }

    public void tick(long time2) {
        for (Tickable tickable : this.tickables) {
            tickable.tick(time2);
        }
    }

    @NotNull
    public H getHandle() {
        return this.handle;
    }

    @ApiStatus.Internal
    public void setHandle(@NotNull H handle) {
        this.handle = handle;
    }
}

