/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.wrapper;

import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerBundle;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityHeadLook;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityVelocity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetPassengers;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import me.tofaa.entitylib.EntityLib;
import me.tofaa.entitylib.container.EntityContainer;
import me.tofaa.entitylib.meta.EntityMeta;
import me.tofaa.entitylib.meta.types.ObjectData;
import me.tofaa.entitylib.tick.Tickable;
import me.tofaa.entitylib.utils.PacketUtil;
import me.tofaa.entitylib.ve.ViewerRule;
import me.tofaa.entitylib.wrapper.WrapperLivingEntity;
import me.tofaa.entitylib.wrapper.WrapperPlayer;
import me.tofaa.entitylib.wrapper.spawning.SpawnPacketProvider;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class WrapperEntity
implements Tickable {
    private final UUID uuid;
    private final int entityId;
    private final EntityType entityType;
    private final EntityMeta entityMeta;
    private boolean ticking;
    protected Location location;
    private Location preRidingLocation;
    protected final Set<UUID> viewers;
    private boolean onGround;
    private boolean spawned;
    private Vector3d velocity;
    private int riding = -1;
    private final Set<Integer> passengers;
    private EntityContainer parent;
    private final List<ViewerRule> viewerRules;

    public WrapperEntity(int entityId, UUID uuid, EntityType entityType, EntityMeta entityMeta) {
        this.entityId = entityId;
        this.uuid = uuid;
        this.entityType = entityType;
        this.entityMeta = entityMeta;
        this.ticking = true;
        this.viewers = ConcurrentHashMap.newKeySet();
        this.passengers = ConcurrentHashMap.newKeySet();
        this.location = new Location(0.0, 0.0, 0.0, 0.0f, 0.0f);
        this.viewerRules = new CopyOnWriteArrayList<ViewerRule>();
        this.velocity = Vector3d.zero();
    }

    public WrapperEntity(int entityId, EntityType entityType) {
        this(entityId, EntityLib.getPlatform().getEntityUuidProvider().provide(entityType), entityType);
    }

    public WrapperEntity(UUID uuid, EntityType entityType) {
        this(EntityLib.getPlatform().getEntityIdProvider().provide(uuid, entityType), uuid, entityType);
    }

    public WrapperEntity(EntityType entityType) {
        this(EntityLib.getPlatform().getEntityUuidProvider().provide(entityType), entityType);
    }

    public WrapperEntity(int entityId, UUID uuid, EntityType entityType) {
        this(entityId, uuid, entityType, EntityMeta.createMeta(entityId, entityType));
    }

    public boolean spawn(Location location, EntityContainer parent) {
        if (this.spawned) {
            return false;
        }
        this.location = location;
        this.spawned = true;
        this.sendPacketsToViewers(new PacketWrapper[]{this.createSpawnPacket(), this.entityMeta.createPacket()});
        if (this instanceof WrapperLivingEntity) {
            WrapperLivingEntity wrapperLivingEntity = (WrapperLivingEntity)this;
            wrapperLivingEntity.createSpawnPackets().forEach(xva$0 -> this.sendPacketsToViewers((PacketWrapper<?>)xva$0));
        }
        this.parent = parent;
        parent.addEntity(this);
        return true;
    }

    public PacketWrapper<?> getSpawnPacket(User user) {
        return SpawnPacketProvider.GENERAL.provide(this);
    }

    public boolean spawn(@NotNull Location location) {
        return this.spawn(location, EntityLib.getApi().getDefaultContainer());
    }

    @ApiStatus.Internal
    public int getObjectData() {
        if (this.entityMeta instanceof ObjectData) {
            return ((ObjectData)((Object)this.entityMeta)).getObjectData();
        }
        return 0;
    }

    @ApiStatus.Internal
    public Optional<Vector3d> createVeloPacket() {
        ObjectData od;
        double veloX = 0.0;
        double veloY = 0.0;
        double veloZ = 0.0;
        if (this.entityMeta instanceof ObjectData && (od = (ObjectData)((Object)this.entityMeta)).requiresVelocityPacketAtSpawn()) {
            WrapperPlayServerEntityVelocity veloPacket = this.getVelocityPacket();
            veloX = veloPacket.getVelocity().getX();
            veloY = veloPacket.getVelocity().getY();
            veloZ = veloPacket.getVelocity().getZ();
        }
        Optional<Vector3d> velocity = veloX == 0.0 && veloY == 0.0 && veloZ == 0.0 ? Optional.of(Vector3d.zero()) : Optional.of(new Vector3d(veloX, veloY, veloZ));
        return velocity;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeEntity(this, true);
        } else {
            this.despawn();
        }
    }

    public void despawn() {
        if (!this.spawned) {
            return;
        }
        this.spawned = false;
        if (this instanceof WrapperPlayer) {
            WrapperPlayer p = (WrapperPlayer)this;
            this.sendPacketsToViewers(new PacketWrapper[]{p.tabListRemovePacket()});
        }
        this.sendPacketToViewers((PacketWrapper<?>)new WrapperPlayServerDestroyEntities(this.entityId));
    }

    public void teleport(@NotNull Location location, boolean onGround) {
        if (!this.spawned) {
            return;
        }
        this.location = location;
        this.onGround = onGround;
        this.sendPacketToViewers((PacketWrapper<?>)new WrapperPlayServerEntityTeleport(this.entityId, location.getPosition(), location.getYaw(), location.getPitch(), onGround));
    }

    public void teleport(@NotNull Location location) {
        this.teleport(location, this.onGround);
    }

    public void addViewer(@NotNull UUID uuid) {
        if (!this.viewers.add(uuid)) {
            return;
        }
        if (this.location == null) {
            if (EntityLib.getApi().getSettings().isDebugMode()) {
                EntityLib.getPlatform().getLogger().warning("Location is null for entity " + this.entityId + ". Cannot spawn.");
            }
            return;
        }
        if (this.spawned) {
            if (this instanceof WrapperPlayer) {
                WrapperPlayer p = (WrapperPlayer)this;
                WrapperEntity.sendPacket(uuid, p.tabListPacket());
            }
            WrapperEntity.sendPacket(uuid, this.createSpawnPacket());
            WrapperEntity.sendPacket(uuid, this.entityMeta.createPacket());
            WrapperEntity.sendPacket(uuid, this.createPassengerPacket());
            if (this instanceof WrapperLivingEntity) {
                WrapperLivingEntity wrapperLivingEntity = (WrapperLivingEntity)this;
                wrapperLivingEntity.createSpawnPackets().forEach(packetWrapper -> WrapperEntity.sendPacket(uuid, packetWrapper));
            }
        }
        if (EntityLib.getApi().getSettings().isDebugMode()) {
            EntityLib.getPlatform().getLogger().info("Added viewer " + uuid + " to entity " + this.entityId);
        }
    }

    public EntityContainer getParentContainer() {
        return this.parent;
    }

    public void sendMessageToViewers(Component message) {
        this.sendPacketToViewers((PacketWrapper<?>)new WrapperPlayServerSystemChatMessage(false, message));
    }

    public void sendActionbarToViewers(Component message) {
        this.sendPacketToViewers((PacketWrapper<?>)new WrapperPlayServerSystemChatMessage(true, message));
    }

    protected PacketWrapper<?> createSpawnPacket() {
        return new WrapperPlayServerSpawnEntity(this.entityId, Optional.of(this.uuid), this.entityType, this.location.getPosition(), this.location.getPitch(), this.location.getYaw(), this.location.getYaw(), this.getObjectData(), this.createVeloPacket());
    }

    public void addViewer(@NotNull User user) {
        this.addViewer(user.getUUID());
    }

    public void addViewerSilently(@NotNull UUID uuid) {
        this.viewers.add(uuid);
    }

    public void addViewerSilently(@NotNull User user) {
        this.addViewerSilently(user.getUUID());
    }

    public void removeViewer(@NotNull UUID uuid) {
        if (!this.viewers.remove(uuid)) {
            return;
        }
        if (this instanceof WrapperPlayer) {
            WrapperPlayer p = (WrapperPlayer)this;
            WrapperEntity.sendPacket(uuid, p.tabListRemovePacket());
        }
        WrapperEntity.sendPacket(uuid, new WrapperPlayServerDestroyEntities(this.entityId));
    }

    public void removeViewer(@NotNull User user) {
        this.removeViewer(user.getUUID());
    }

    public void removeViewerSilently(@NotNull UUID uuid) {
        this.viewers.remove(uuid);
    }

    public void removeViewerSilently(@NotNull User user) {
        this.removeViewerSilently(user.getUUID());
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    @NotNull
    public Vector3d getVelocity() {
        return this.velocity;
    }

    public void setVelocity(@NotNull Vector3d velocity) {
        this.velocity = velocity;
        this.sendPacketToViewers((PacketWrapper<?>)this.getVelocityPacket());
    }

    public double getX() {
        return this.location.getX();
    }

    public double getY() {
        return this.location.getY();
    }

    public double getZ() {
        return this.location.getZ();
    }

    public float getYaw() {
        return this.location.getYaw();
    }

    public float getPitch() {
        return this.location.getPitch();
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NotNull
    public EntityMeta getEntityMeta() {
        return this.entityMeta;
    }

    public <T extends EntityMeta> T getEntityMeta(@NotNull Class<T> metaClass) {
        return (T)((EntityMeta)metaClass.cast(this.entityMeta));
    }

    public <T extends EntityMeta> void consumeEntityMeta(@NotNull Class<T> metaClass, @NotNull Consumer<T> consumer) {
        T meta = this.getEntityMeta(metaClass);
        consumer.accept(meta);
    }

    public void consumeMeta(@NotNull Consumer<EntityMeta> consumer) {
        consumer.accept(this.entityMeta);
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    @NotNull
    public Set<Integer> getPassengers() {
        return Collections.unmodifiableSet(this.passengers);
    }

    @Nullable
    public WrapperEntity getRiding() {
        return EntityLib.getApi().getEntity(this.riding);
    }

    protected WrapperPlayServerSetPassengers createPassengerPacket() {
        if (this.passengers.isEmpty()) {
            return null;
        }
        return new WrapperPlayServerSetPassengers(this.entityId, this.passengers.stream().mapToInt(i -> i).toArray());
    }

    public @UnmodifiableView Collection<ViewerRule> getViewerRules() {
        return Collections.unmodifiableCollection(this.viewerRules);
    }

    public void addViewerRule(@NotNull ViewerRule rule) {
        this.viewerRules.add(rule);
    }

    public void removeViewerRule(@NotNull ViewerRule rule) {
        this.viewerRules.remove(rule);
    }

    public void removeViewerRule(int index) {
        this.viewerRules.remove(index);
    }

    public void clearViewerRules() {
        this.viewerRules.clear();
    }

    @Nullable
    public ViewerRule getViewerRule(int index) {
        if (this.viewerRules.size() >= index - 1) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        return this.viewerRules.get(index);
    }

    public WrapperPlayServerEntityVelocity getVelocityPacket() {
        Vector3d velocity = this.velocity.multiply(400.0);
        return new WrapperPlayServerEntityVelocity(this.entityId, velocity);
    }

    public boolean isSpawned() {
        return this.spawned;
    }

    @Override
    public boolean isTicking() {
        return this.ticking;
    }

    @Override
    public void setTicking(boolean ticking) {
        this.ticking = ticking;
    }

    public boolean hasVelocity() {
        if (this.isOnGround()) {
            return Double.compare(this.velocity.x, 0.0) != 0 || Double.compare(this.velocity.z, 0.0) != 0 || this.velocity.y > 0.0;
        }
        return !this.velocity.equals((Object)Vector3d.zero());
    }

    public void rotateHead(float yaw, float pitch) {
        this.sendPacketsToViewersIfSpawned(new PacketWrapper[]{new WrapperPlayServerEntityRotation(this.entityId, yaw, pitch, this.onGround), new WrapperPlayServerEntityHeadLook(this.entityId, yaw)});
        this.location.setYaw(yaw);
        this.location.setPitch(pitch);
    }

    public void rotateHead(@NotNull Location location) {
        this.rotateHead(location.getYaw(), location.getPitch());
    }

    public void rotateHead(@NotNull WrapperEntity entity) {
        this.rotateHead(entity.getLocation());
    }

    public void refresh() {
        if (!this.spawned) {
            return;
        }
        this.sendPacketsToViewers(new PacketWrapper[]{this.entityMeta.createPacket(), this.createPassengerPacket()});
    }

    public void sendPacketToViewers(PacketWrapper<?> packet) {
        if (EntityLib.getApi().getSettings().shouldForceBundles()) {
            this.viewers.forEach(uuid -> {
                WrapperEntity.sendPacket(uuid, new WrapperPlayServerBundle());
                WrapperEntity.sendPacket(uuid, packet);
                WrapperEntity.sendPacket(uuid, new WrapperPlayServerBundle());
            });
        } else {
            this.viewers.forEach(uuid -> WrapperEntity.sendPacket(uuid, packet));
        }
    }

    public void sendPacketsToViewers(PacketWrapper<?> ... wrappers) {
        for (PacketWrapper<?> wrapper : wrappers) {
            this.sendPacketToViewers(wrapper);
        }
    }

    public void sendPacketToViewersIfSpawned(PacketWrapper<?> packet) {
        if (this.spawned) {
            this.sendPacketToViewers(packet);
        }
    }

    public void sendPacketsToViewersIfSpawned(PacketWrapper<?> ... wrappers) {
        if (this.spawned) {
            this.sendPacketsToViewers(wrappers);
        }
    }

    private static void sendPacket(UUID user, PacketWrapper<?> wrapper) {
        if (wrapper == null) {
            return;
        }
        Object channel = EntityLib.getApi().getPacketEvents().getProtocolManager().getChannel(user);
        if (channel == null) {
            if (EntityLib.getApi().getSettings().isDebugMode()) {
                EntityLib.getPlatform().getLogger().warning("Failed to send packet to " + user + " because the channel was null. They may be disconnected/not online.");
            }
            return;
        }
        if (wrapper instanceof WrapperPlayServerEntityMetadata) {
            PacketUtil.renderPacket(user, (WrapperPlayServerEntityMetadata)wrapper);
        }
        EntityLib.getApi().getPacketEvents().getProtocolManager().sendPacket(channel, wrapper);
    }

    public boolean hasNoGravity() {
        return this.entityMeta.hasNoGravity();
    }

    public void setHasNoGravity(boolean hasNoGravity) {
        this.entityMeta.setHasNoGravity(hasNoGravity);
        this.refresh();
    }

    public void addPassenger(int passenger) {
        if (this.passengers.contains(passenger)) {
            throw new IllegalArgumentException("Passenger already exists");
        }
        this.passengers.add(passenger);
        this.sendPacketToViewers((PacketWrapper<?>)this.createPassengerPacket());
        WrapperEntity e = EntityLib.getApi().getEntity(passenger);
        if (e != null) {
            e.riding = this.entityId;
            e.preRidingLocation = e.location;
        }
    }

    @Nullable
    public Location getPreRidingLocation() {
        return this.preRidingLocation;
    }

    public int getRidingId() {
        return this.riding;
    }

    public void addPassengers(int ... passengers) {
        for (int passenger : passengers) {
            this.addPassenger(passenger);
        }
    }

    public void addPassenger(@NotNull WrapperEntity passenger) {
        this.addPassenger(passenger.getEntityId());
    }

    public void addPassengers(WrapperEntity ... passengers) {
        for (WrapperEntity passenger : passengers) {
            this.addPassenger(passenger);
        }
    }

    public void removePassenger(int passenger) {
        if (!this.passengers.contains(passenger)) {
            throw new IllegalArgumentException("Passenger does not exist");
        }
        this.passengers.remove(passenger);
        this.sendPacketToViewers((PacketWrapper<?>)this.createPassengerPacket());
        WrapperEntity e = EntityLib.getApi().getEntity(passenger);
        if (e != null) {
            e.riding = -1;
            e.teleport(e.preRidingLocation, e.onGround);
        }
    }

    public boolean hasPassenger(int passenger) {
        return this.passengers.contains(passenger);
    }

    public boolean hasPassenger(@NotNull WrapperEntity passenger) {
        return this.hasPassenger(passenger.getEntityId());
    }

    public void removePassengers(int ... passengers) {
        for (int passenger : passengers) {
            this.removePassenger(passenger);
        }
    }

    public void removePassenger(@NotNull WrapperEntity passenger) {
        this.removePassenger(passenger.getEntityId());
    }

    public void removePassengers(WrapperEntity ... passengers) {
        for (WrapperEntity passenger : passengers) {
            this.removePassenger(passenger);
        }
    }

    public boolean isRiding() {
        return this.riding != -1;
    }

    @NotNull
    public Set<UUID> getViewers() {
        return Collections.unmodifiableSet(this.viewers);
    }

    public boolean hasViewer(@NotNull UUID uuid) {
        return this.viewers.contains(uuid);
    }

    public boolean hasViewer(@NotNull User user) {
        return this.hasViewer(user.getUUID());
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public void tick(long time2) {
        WrapperEntity riding;
        if (this.isRiding() && (riding = this.getRiding()) != null) {
            Location l = riding.getLocation();
            this.location = new Location(l.getX(), l.getY() + 1.0, l.getZ(), l.getYaw(), l.getPitch());
        }
    }
}

