/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.wrapper;

import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.potion.PotionType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEffect;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerRemoveEntityEffect;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.tofaa.entitylib.wrapper.WrapperLivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapperEntityPotionEffect {
    private final WrapperLivingEntity entity;
    private final Map<PotionType, WrapperPotionEffect> effects = new ConcurrentHashMap<PotionType, WrapperPotionEffect>();
    private boolean notifyChanges = true;

    public WrapperEntityPotionEffect(WrapperLivingEntity entity) {
        this.entity = entity;
    }

    public void addPotionEffect(PotionType type, int amplifier, int duration, boolean ambient, boolean visible, boolean showIcons, @Nullable NBTCompound factorData) {
        WrapperPotionEffect effect = new WrapperPotionEffect(type, amplifier, duration, ambient, visible, showIcons, factorData);
        this.effects.put(type, effect);
        this.entity.sendPacketToViewers((PacketWrapper<?>)this.createEffectPacket(effect));
    }

    public void addPotionEffect(PotionType type, int amplifier, int duration, byte flags, @Nullable NBTCompound factorData) {
        BitSet flagsBitSet = BitSet.valueOf(new byte[]{flags});
        boolean ambient = flagsBitSet.get(0);
        boolean visible = flagsBitSet.get(1);
        boolean icons = flagsBitSet.get(2);
        this.addPotionEffect(type, amplifier, duration, ambient, visible, icons, factorData);
    }

    public void addPotionEffect(PotionType type, int amplifier, int duration, byte flags, boolean hasFactorData, @Nullable NBTCompound factorData) {
        this.addPotionEffect(type, amplifier, duration, flags, (NBTCompound)(hasFactorData ? factorData : null));
    }

    public void addPotionEffect(PotionType type, int amplifier, int duration, byte flags) {
        this.addPotionEffect(type, amplifier, duration, flags, false, null);
    }

    public void removePotionEffect(@NotNull PotionType potionType) {
        if (this.effects.remove(potionType) != null) {
            this.entity.sendPacketsToViewers(new PacketWrapper[]{this.createRemoveEffectPacket(potionType)});
        }
    }

    public void clearPotionEffects() {
        new ArrayList<PotionType>(this.effects.keySet()).forEach(this::removePotionEffect);
    }

    @NotNull
    public List<WrapperPlayServerEntityEffect> createEffectPackets() {
        ArrayList<WrapperPlayServerEntityEffect> packets = new ArrayList<WrapperPlayServerEntityEffect>();
        this.effects.forEach((potionType, effect) -> packets.add(this.createEffectPacket((WrapperPotionEffect)effect)));
        return packets;
    }

    @NotNull
    public WrapperPlayServerEntityEffect createEffectPacket(@NotNull WrapperPotionEffect effect) {
        PotionType potionType = effect.getPotionType();
        int amplifier = effect.getAmplifier();
        int duration = effect.getDuration();
        boolean ambient = effect.isAmbient();
        boolean visible = effect.isVisible();
        boolean icons = effect.hasIcons();
        NBTCompound factorData = effect.getFactorData();
        int flags = 0;
        flags |= ambient ? 1 : 0;
        flags |= visible ? 2 : 0;
        WrapperPlayServerEntityEffect wrapperPlayServerEntityEffect = new WrapperPlayServerEntityEffect(0, null, 0, 0, (byte)(flags |= icons ? 4 : 0));
        wrapperPlayServerEntityEffect.setEntityId(this.entity.getEntityId());
        wrapperPlayServerEntityEffect.setPotionType(potionType);
        wrapperPlayServerEntityEffect.setEffectAmplifier(amplifier);
        wrapperPlayServerEntityEffect.setEffectDurationTicks(duration);
        wrapperPlayServerEntityEffect.setFactorData(factorData);
        return wrapperPlayServerEntityEffect;
    }

    @NotNull
    public WrapperPlayServerRemoveEntityEffect createRemoveEffectPacket(@NotNull PotionType potionType) {
        return new WrapperPlayServerRemoveEntityEffect(this.entity.getEntityId(), potionType);
    }

    public void refresh() {
        if (this.notifyChanges) {
            new ArrayList<WrapperPotionEffect>(this.effects.values()).forEach(effect -> {
                WrapperPlayServerEntityEffect wrapperPlayServerEntityEffect = this.createEffectPacket((WrapperPotionEffect)effect);
                this.entity.sendPacketToViewers((PacketWrapper<?>)wrapperPlayServerEntityEffect);
            });
        }
    }

    public boolean isNotifyingChanges() {
        return this.notifyChanges;
    }

    public void setNotifyChanges(boolean notifyChanges) {
        this.notifyChanges = notifyChanges;
        this.refresh();
    }

    public static class WrapperPotionEffect {
        private final PotionType potionType;
        private final int amplifier;
        private final int duration;
        private final boolean ambient;
        private final boolean visible;
        private final boolean icons;
        @Nullable
        private final NBTCompound factorData;

        private WrapperPotionEffect(PotionType potionType, int amplifier, int duration, boolean ambient, boolean visible, boolean icons, @Nullable NBTCompound factorData) {
            this.potionType = potionType;
            this.amplifier = amplifier;
            this.duration = duration;
            this.ambient = ambient;
            this.visible = visible;
            this.icons = icons;
            this.factorData = factorData;
        }

        public PotionType getPotionType() {
            return this.potionType;
        }

        public int getAmplifier() {
            return this.amplifier;
        }

        public int getDuration() {
            return this.duration;
        }

        public boolean isAmbient() {
            return this.ambient;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean hasIcons() {
            return this.icons;
        }

        @Nullable
        public NBTCompound getFactorData() {
            return this.factorData;
        }
    }
}

