/*
 * Decompiled with CFR 0.152.
 */
package me.tofaa.entitylib.wrapper.spawning;

import com.github.retrooper.packetevents.protocol.entity.data.EntityMetadataProvider;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnExperienceOrb;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnLivingEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnPainting;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnWeatherEntity;
import java.util.Optional;
import me.tofaa.entitylib.meta.other.PaintingMeta;
import me.tofaa.entitylib.utils.Check;
import me.tofaa.entitylib.wrapper.WrapperExperienceOrbEntity;
import me.tofaa.entitylib.wrapper.spawning.SpawnPacketProvider;
import org.jetbrains.annotations.NotNull;

interface SpawnPacketProviders {
    @NotNull
    public static final SpawnPacketProvider<WrapperPlayServerSpawnExperienceOrb> EXPERIENCE_ORB = entity -> {
        Check.stateCondition(!(entity instanceof WrapperExperienceOrbEntity), "Attempted to use spawn packet provider for Experience orbs on a non ExperienceOrb entity. Please use an instance of WrapperExperienceOrbEntity.");
        WrapperExperienceOrbEntity expEntity = (WrapperExperienceOrbEntity)entity;
        return new WrapperPlayServerSpawnExperienceOrb(entity.getEntityId(), entity.getX(), entity.getY(), entity.getZ(), expEntity.getExperience());
    };
    @NotNull
    public static final SpawnPacketProvider<WrapperPlayServerSpawnEntity> GENERAL = entity -> {
        Location location = entity.getLocation();
        return new WrapperPlayServerSpawnEntity(entity.getEntityId(), Optional.of(entity.getUuid()), entity.getEntityType(), location.getPosition(), location.getPitch(), location.getYaw(), location.getYaw(), entity.getObjectData(), entity.createVeloPacket());
    };
    @NotNull
    public static final SpawnPacketProvider<WrapperPlayServerSpawnWeatherEntity> LEGACY_WEATHER_ENTITY = entity -> {
        throw new RuntimeException("Not supported yet");
    };
    @NotNull
    public static final SpawnPacketProvider<WrapperPlayServerSpawnPainting> LEGACY_PAINTING = entity -> {
        Check.stateCondition(!(entity.getEntityMeta() instanceof PaintingMeta), "Attempted to use spawn packet provider for paintings but not using an entity with PaintingMeta.");
        PaintingMeta meta = entity.getEntityMeta(PaintingMeta.class);
        return new WrapperPlayServerSpawnPainting(entity.getEntityId(), entity.getUuid(), meta.getType().asProtocolType(), entity.getLocation().getPosition().toVector3i(), meta.getDirection());
    };
    @NotNull
    public static final SpawnPacketProvider<WrapperPlayServerSpawnLivingEntity> PRE_1_19_LIVING = entity -> {
        Location location = entity.getLocation();
        return new WrapperPlayServerSpawnLivingEntity(entity.getEntityId(), entity.getUuid(), entity.getEntityType(), location, location.getPitch(), entity.getVelocity(), (EntityMetadataProvider)entity.getEntityMeta());
    };
}

