/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.worldguard.entries.fact;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.engine.paper.entry.PlaceholderParser;
import com.typewritermc.engine.paper.entry.entries.GroupEntry;
import com.typewritermc.engine.paper.entry.entries.ReadableFactEntry;
import com.typewritermc.engine.paper.facts.FactData;
import com.typewritermc.engine.paper.facts.FactId;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Entry(name="in_region_fact", description="If the player is in a WorldGuard region", color="#5843e6", icon="fa6-solid:road-barrier")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B?\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/typewritermc/worldguard/entries/fact/InRegionFact;", "Lcom/typewritermc/engine/paper/entry/entries/ReadableFactEntry;", "id", "", "name", "comment", "group", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/GroupEntry;", "region", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/typewritermc/core/entries/Ref;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "getComment", "getGroup", "()Lcom/typewritermc/core/entries/Ref;", "getRegion", "readSinglePlayer", "Lcom/typewritermc/engine/paper/facts/FactData;", "player", "Lorg/bukkit/entity/Player;", "WorldGuardExtension"})
@SourceDebugExtension(value={"SMAP\nInRegionFact.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InRegionFact.kt\ncom/typewritermc/worldguard/entries/fact/InRegionFact\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n6#2:41\n1761#3,3:42\n*S KotlinDebug\n*F\n+ 1 InRegionFact.kt\ncom/typewritermc/worldguard/entries/fact/InRegionFact\n*L\n28#1:41\n37#1:42,3\n*E\n"})
public final class InRegionFact
implements ReadableFactEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String comment;
    @NotNull
    private final Ref<GroupEntry> group;
    @NotNull
    private final String region;

    public InRegionFact(@NotNull String id, @NotNull String name, @NotNull String comment, @NotNull Ref<GroupEntry> group, @NotNull String region) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.group = group;
        this.region = region;
    }

    public /* synthetic */ InRegionFact(String string, String string2, String string3, Ref ref, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            boolean $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(GroupEntry.class), null, 4, null);
        }
        if ((n & 0x10) != 0) {
            string4 = "";
        }
        this(string, string2, string3, (Ref<GroupEntry>)ref, string4);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getComment() {
        return this.comment;
    }

    @NotNull
    public Ref<GroupEntry> getGroup() {
        return this.group;
    }

    @NotNull
    public final String getRegion() {
        return this.region;
    }

    @NotNull
    public FactData readSinglePlayer(@NotNull Player player) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
            RegionManager regionManager = regionContainer.get(BukkitAdapter.adapt((World)player.getWorld()));
            RegionManager regionManager2 = regionManager;
            if (regionManager2 == null || (regionManager2 = regionManager2.getApplicableRegions(BukkitAdapter.asBlockVector((Location)player.getLocation()))) == null) {
                return new FactData(0, null, 2, null);
            }
            RegionManager regions = regionManager2;
            Set set = regions.getRegions();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRegions(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ProtectedRegion it = (ProtectedRegion)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.region)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        int value = bl ? 1 : 0;
        return new FactData(value, null, 2, null);
    }

    @NotNull
    public FactData readForPlayersGroup(@NotNull Player player) {
        return super.readForPlayersGroup(player);
    }

    @NotNull
    public FactData readForGroup-1dlmaes(@NotNull String groupId) {
        return super.readForGroup-1dlmaes(groupId);
    }

    @NotNull
    public PlaceholderParser parser() {
        return super.parser();
    }

    @Nullable
    public FactId identifier(@NotNull Player player) {
        return super.identifier(player);
    }

    public InRegionFact() {
        this(null, null, null, null, null, 31, null);
    }
}

