/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.action;

import com.google.gson.annotations.SerializedName;
import com.typewritermc.core.books.pages.PageType;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Default;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.core.extension.annotations.Page;
import com.typewritermc.engine.paper.entry.Criteria;
import com.typewritermc.engine.paper.entry.Modifier;
import com.typewritermc.engine.paper.entry.TriggerableEntry;
import com.typewritermc.engine.paper.entry.entries.ActionEntry;
import com.typewritermc.engine.paper.entry.entries.ActionTrigger;
import com.typewritermc.engine.paper.entry.entries.EventTrigger;
import com.typewritermc.engine.paper.entry.temporal.TemporalSettings;
import com.typewritermc.engine.paper.entry.temporal.TemporalStartTrigger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Entry(name="cinematic", description="Start a new cinematic", color="#D32F2F", icon="fa-solid:camera-retro")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001Bo\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0006\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\f\u0010%\u001a\u00020&*\u00020'H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001c\u0010\r\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u0014R\u001c\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u001b\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010\u0010\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b \u0010\u001b\u001a\u0004\b!\u0010\u001fR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0017\u00a8\u0006("}, d2={"Lcom/typewritermc/basic/entries/action/CinematicEntry;", "Lcom/typewritermc/engine/paper/entry/entries/ActionEntry;", "id", "", "name", "criteria", "", "Lcom/typewritermc/engine/paper/entry/Criteria;", "modifiers", "Lcom/typewritermc/engine/paper/entry/Modifier;", "triggers", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/TriggerableEntry;", "pageId", "blockChatMessages", "", "blockActionBarMessages", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;ZZ)V", "getId", "()Ljava/lang/String;", "getName", "getCriteria", "()Ljava/util/List;", "getModifiers", "getTriggers", "getPageId$annotations", "()V", "getPageId", "getBlockChatMessages$annotations", "getBlockChatMessages", "()Z", "getBlockActionBarMessages$annotations", "getBlockActionBarMessages", "eventTriggers", "Lcom/typewritermc/engine/paper/entry/entries/EventTrigger;", "getEventTriggers", "execute", "", "Lcom/typewritermc/engine/paper/entry/entries/ActionTrigger;", "BasicExtension"})
public final class CinematicEntry
implements ActionEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final List<Criteria> criteria;
    @NotNull
    private final List<Modifier> modifiers;
    @NotNull
    private final List<Ref<TriggerableEntry>> triggers;
    @SerializedName(value="page")
    @NotNull
    private final String pageId;
    private final boolean blockChatMessages;
    private final boolean blockActionBarMessages;

    public CinematicEntry(@NotNull String id, @NotNull String name, @NotNull List<Criteria> criteria, @NotNull List<Modifier> modifiers, @NotNull List<Ref<TriggerableEntry>> triggers, @NotNull String pageId, boolean blockChatMessages, boolean blockActionBarMessages) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(criteria, (String)"criteria");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        this.id = id;
        this.name = name;
        this.criteria = criteria;
        this.modifiers = modifiers;
        this.triggers = triggers;
        this.pageId = pageId;
        this.blockChatMessages = blockChatMessages;
        this.blockActionBarMessages = blockActionBarMessages;
    }

    public /* synthetic */ CinematicEntry(String string, String string2, List list, List list2, List list3, String string3, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            string3 = "";
        }
        if ((n & 0x40) != 0) {
            bl = true;
        }
        if ((n & 0x80) != 0) {
            bl2 = true;
        }
        this(string, string2, list, list2, list3, string3, bl, bl2);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<Criteria> getCriteria() {
        return this.criteria;
    }

    @NotNull
    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    @NotNull
    public List<Ref<TriggerableEntry>> getTriggers() {
        return this.triggers;
    }

    @NotNull
    public final String getPageId() {
        return this.pageId;
    }

    @Page(type=PageType.CINEMATIC)
    @Help(text="The cinematic page to start.")
    public static /* synthetic */ void getPageId$annotations() {
    }

    public final boolean getBlockChatMessages() {
        return this.blockChatMessages;
    }

    @Default(json="true")
    @Help(text="Whether to block chat messages from showing to the player while in the cinematic.")
    public static /* synthetic */ void getBlockChatMessages$annotations() {
    }

    public final boolean getBlockActionBarMessages() {
        return this.blockActionBarMessages;
    }

    @Default(json="true")
    @Help(text="Whether to block actionbar messages from showing to the player while in the cinematic.")
    public static /* synthetic */ void getBlockActionBarMessages$annotations() {
    }

    @NotNull
    public List<EventTrigger> getEventTriggers() {
        return CollectionsKt.listOf((Object)new TemporalStartTrigger(this.pageId, super.getEventTriggers(), new TemporalSettings(this.blockChatMessages, this.blockActionBarMessages)));
    }

    public void execute(@NotNull ActionTrigger $this$execute) {
        Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"<this>");
    }

    public CinematicEntry() {
        this(null, null, null, null, null, null, false, false, 255, null);
    }
}

