/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.audience;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.AudienceFilterEntry;
import com.typewritermc.engine.paper.entry.entries.TickableDisplay;
import com.typewritermc.engine.paper.utils.CronExpression;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/typewritermc/basic/entries/audience/CronAudienceDisplay;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/TickableDisplay;", "ref", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilterEntry;", "cron", "Lcom/typewritermc/engine/paper/utils/CronExpression;", "<init>", "(Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/engine/paper/utils/CronExpression;)V", "lastUpdate", "Ljava/time/LocalDateTime;", "active", "", "getActive", "()Z", "filter", "player", "Lorg/bukkit/entity/Player;", "tick", "", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nCronAudience.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CronAudience.kt\ncom/typewritermc/basic/entries/audience/CronAudienceDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1869#2,2:69\n*S KotlinDebug\n*F\n+ 1 CronAudience.kt\ncom/typewritermc/basic/entries/audience/CronAudienceDisplay\n*L\n66#1:69,2\n*E\n"})
public final class CronAudienceDisplay
extends AudienceFilter
implements TickableDisplay {
    @NotNull
    private final CronExpression cron;
    @NotNull
    private LocalDateTime lastUpdate;

    public CronAudienceDisplay(@NotNull Ref<? extends AudienceFilterEntry> ref, @NotNull CronExpression cron) {
        Intrinsics.checkNotNullParameter(ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)cron, (String)"cron");
        super(ref);
        this.cron = cron;
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        this.lastUpdate = localDateTime;
    }

    public final boolean getActive() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime previousMinute = now.minusMinutes(1L);
        return this.cron.nextLocalDateTimeAfter(previousMinute).isBefore(now);
    }

    public boolean filter(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getActive();
    }

    public void tick() {
        LocalDateTime newTime = LocalDateTime.now();
        if (this.cron.getWithSeconds() && newTime.getSecond() == this.lastUpdate.getSecond()) {
            return;
        }
        if (!this.cron.getWithSeconds() && newTime.getMinute() == this.lastUpdate.getMinute()) {
            return;
        }
        Intrinsics.checkNotNull((Object)newTime);
        this.lastUpdate = newTime;
        boolean active = this.getActive();
        Iterable $this$forEach$iv = this.getConsideredPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.updateFilter(it, active);
        }
    }
}

