/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.audience;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.ClientBoundPacket;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerTimeUpdate;
import com.typewritermc.engine.paper.entry.entries.AudienceDisplay;
import com.typewritermc.engine.paper.entry.entries.TickableDisplay;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import com.typewritermc.engine.paper.interaction.InterceptionBundle;
import com.typewritermc.engine.paper.interaction.PacketInterceptorKt;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/typewritermc/basic/entries/audience/FreezeTimeAudienceDisplay;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceDisplay;", "Lcom/typewritermc/engine/paper/entry/entries/TickableDisplay;", "time", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "", "<init>", "(Lcom/typewritermc/engine/paper/entry/entries/Var;)V", "interceptors", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/typewritermc/engine/paper/interaction/InterceptionBundle;", "onPlayerAdd", "", "player", "Lorg/bukkit/entity/Player;", "tick", "onPlayerRemove", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nFreezeTimeAudienceEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreezeTimeAudienceEntry.kt\ncom/typewritermc/basic/entries/audience/FreezeTimeAudienceDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1869#2,2:76\n*S KotlinDebug\n*F\n+ 1 FreezeTimeAudienceEntry.kt\ncom/typewritermc/basic/entries/audience/FreezeTimeAudienceDisplay\n*L\n63#1:76,2\n*E\n"})
public final class FreezeTimeAudienceDisplay
extends AudienceDisplay
implements TickableDisplay {
    @NotNull
    private final Var<Long> time;
    @NotNull
    private final ConcurrentHashMap<UUID, InterceptionBundle> interceptors;

    public FreezeTimeAudienceDisplay(@NotNull Var<Long> time) {
        Intrinsics.checkNotNullParameter(time, (String)"time");
        this.time = time;
        this.interceptors = new ConcurrentHashMap();
    }

    public void onPlayerAdd(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ((Map)this.interceptors).put(player.getUniqueId(), PacketInterceptorKt.interceptPackets((Player)player, arg_0 -> FreezeTimeAudienceDisplay.onPlayerAdd$lambda$1(this, player, arg_0)));
        player.setPlayerTime(((Number)Var.get$default(this.time, (Player)player, null, (int)2, null)).longValue(), false);
    }

    public void tick() {
        Iterable $this$forEach$iv = this.getPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            player.setPlayerTime(((Number)Var.get$default(this.time, (Player)player, null, (int)2, null)).longValue(), false);
            PlayerPacketsKt.sendPacketTo((PacketWrapper)((PacketWrapper)new WrapperPlayServerTimeUpdate(player.getWorld().getGameTime(), ((Number)Var.get$default(this.time, (Player)player, null, (int)2, null)).longValue(), false)), (Player)player);
        }
    }

    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        InterceptionBundle interceptionBundle = this.interceptors.remove(player.getUniqueId());
        if (interceptionBundle != null) {
            interceptionBundle.cancel();
        }
        player.resetPlayerTime();
        PlayerPacketsKt.sendPacketTo((PacketWrapper)((PacketWrapper)new WrapperPlayServerTimeUpdate(player.getWorld().getGameTime(), player.getPlayerTime(), false)), (Player)player);
    }

    private static final Unit onPlayerAdd$lambda$1$lambda$0(FreezeTimeAudienceDisplay this$0, Player $player, PacketSendEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        WrapperPlayServerTimeUpdate packet = new WrapperPlayServerTimeUpdate(event);
        packet.setTimeOfDay(((Number)Var.get$default(this$0.time, (Player)$player, null, (int)2, null)).longValue());
        packet.setTickTime(false);
        return Unit.INSTANCE;
    }

    private static final Unit onPlayerAdd$lambda$1(FreezeTimeAudienceDisplay this$0, Player $player, InterceptionBundle $this$interceptPackets) {
        Intrinsics.checkNotNullParameter((Object)$this$interceptPackets, (String)"$this$interceptPackets");
        $this$interceptPackets.invoke((ClientBoundPacket)PacketType.Play.Server.TIME_UPDATE, arg_0 -> FreezeTimeAudienceDisplay.onPlayerAdd$lambda$1$lambda$0(this$0, $player, arg_0));
        return Unit.INSTANCE;
    }
}

