/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.audience;

import com.typewritermc.basic.entries.audience.TimerAudienceDisplay;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.engine.paper.entry.PlaceholderParser;
import com.typewritermc.engine.paper.entry.TriggerableEntry;
import com.typewritermc.engine.paper.entry.entries.AudienceDisplay;
import com.typewritermc.engine.paper.entry.entries.AudienceEntry;
import com.typewritermc.engine.paper.entry.entries.ConstVar;
import com.typewritermc.engine.paper.entry.entries.Var;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entry(name="timer_audience", description="Triggers an action every specified duration when the player is in the audience", color="#4CAF50", icon="mdi:timer-outline")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B;\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/typewritermc/basic/entries/audience/TimerAudienceEntry;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceEntry;", "id", "", "name", "duration", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "Ljava/time/Duration;", "onTimer", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/TriggerableEntry;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/typewritermc/engine/paper/entry/entries/Var;Lcom/typewritermc/core/entries/Ref;)V", "getId", "()Ljava/lang/String;", "getName", "getDuration", "()Lcom/typewritermc/engine/paper/entry/entries/Var;", "getOnTimer", "()Lcom/typewritermc/core/entries/Ref;", "display", "Lcom/typewritermc/engine/paper/entry/entries/AudienceDisplay;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "BasicExtension"})
@SourceDebugExtension(value={"SMAP\nTimerAudienceEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimerAudienceEntry.kt\ncom/typewritermc/basic/entries/audience/TimerAudienceEntry\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n*L\n1#1,72:1\n6#2:73\n*S KotlinDebug\n*F\n+ 1 TimerAudienceEntry.kt\ncom/typewritermc/basic/entries/audience/TimerAudienceEntry\n*L\n44#1:73\n*E\n"})
public final class TimerAudienceEntry
implements AudienceEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final Var<Duration> duration;
    @NotNull
    private final Ref<TriggerableEntry> onTimer;

    public TimerAudienceEntry(@NotNull String id, @NotNull String name, @NotNull Var<Duration> duration, @NotNull Ref<TriggerableEntry> onTimer) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(duration, (String)"duration");
        Intrinsics.checkNotNullParameter(onTimer, (String)"onTimer");
        this.id = id;
        this.name = name;
        this.duration = duration;
        this.onTimer = onTimer;
    }

    public /* synthetic */ TimerAudienceEntry(String string, String string2, Var var, Ref ref, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            Duration duration = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            var = (Var)new ConstVar((Object)duration);
        }
        if ((n & 8) != 0) {
            boolean $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(TriggerableEntry.class), null, 4, null);
        }
        this(string, string2, (Var<Duration>)var, (Ref<TriggerableEntry>)ref);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Var<Duration> getDuration() {
        return this.duration;
    }

    @NotNull
    public final Ref<TriggerableEntry> getOnTimer() {
        return this.onTimer;
    }

    @Nullable
    public Object display(@NotNull Continuation<? super AudienceDisplay> $completion) {
        return new TimerAudienceDisplay(this.duration, this.onTimer);
    }

    @NotNull
    public PlaceholderParser parser() {
        return super.parser();
    }

    public TimerAudienceEntry() {
        this(null, null, null, null, 15, null);
    }
}

