/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.basic.entries.bound;

import com.typewritermc.basic.entries.bound.PlayerRadiusInteractionBound;
import com.typewritermc.core.interaction.InteractionBound;
import com.typewritermc.core.interaction.InteractionBoundState;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.entries.EventTrigger;
import com.typewritermc.engine.paper.interaction.ListenerInteractionBound;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u0019\u001a\u00020\u001aH\u0096@\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0003J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020#H\u0003J\u000e\u0010$\u001a\u00020\u001aH\u0096@\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/typewritermc/basic/entries/bound/PlayerRadiusInteractionBound;", "Lcom/typewritermc/engine/paper/interaction/ListenerInteractionBound;", "player", "Lorg/bukkit/entity/Player;", "radius", "", "zoom", "", "priority", "", "interruptionTriggers", "", "Lcom/typewritermc/engine/paper/entry/entries/EventTrigger;", "<init>", "(Lorg/bukkit/entity/Player;DZILjava/util/List;)V", "getPriority", "()I", "getInterruptionTriggers", "()Ljava/util/List;", "startLocation", "Lorg/bukkit/Location;", "Lorg/jetbrains/annotations/NotNull;", "key", "Lorg/bukkit/NamespacedKey;", "Lorg/jetbrains/annotations/Nullable;", "initialize", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateZoom", "distance", "calculateZoom", "onMove", "event", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "teardown", "BasicExtension"})
public final class PlayerRadiusInteractionBound
implements ListenerInteractionBound {
    @NotNull
    private final Player player;
    private final double radius;
    private final boolean zoom;
    private final int priority;
    @NotNull
    private final List<EventTrigger> interruptionTriggers;
    @NotNull
    private final Location startLocation;
    @NotNull
    private final NamespacedKey key;

    public PlayerRadiusInteractionBound(@NotNull Player player, double radius, boolean zoom, int priority, @NotNull List<? extends EventTrigger> interruptionTriggers) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(interruptionTriggers, (String)"interruptionTriggers");
        this.player = player;
        this.radius = radius;
        this.zoom = zoom;
        this.priority = priority;
        this.interruptionTriggers = interruptionTriggers;
        Location location = this.player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        this.startLocation = location;
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)"zoom", (Plugin)((Plugin)TypewriterPaperPluginKt.getPlugin()));
        Intrinsics.checkNotNull((Object)namespacedKey);
        this.key = namespacedKey;
    }

    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public List<EventTrigger> getInterruptionTriggers() {
        return this.interruptionTriggers;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object initialize(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof initialize.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ PlayerRadiusInteractionBound this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.initialize((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = super.initialize((Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                this.updateZoom(0.0);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void updateZoom(double distance) {
        block1: {
            if (!this.zoom) {
                return;
            }
            double zoom = this.calculateZoom(distance);
            AttributeModifier modifier = new AttributeModifier(this.key, zoom, AttributeModifier.Operation.MULTIPLY_SCALAR_1);
            AttributeInstance attributeInstance = this.player.getAttribute(Attribute.MOVEMENT_SPEED);
            if (attributeInstance == null) break block1;
            AttributeInstance attribute = attributeInstance;
            boolean bl = false;
            attribute.removeModifier((Key)this.key);
            attribute.addModifier(modifier);
        }
    }

    private final double calculateZoom(double distance) {
        double minZoom = -0.6;
        double maxZoom = 0.0;
        double normalizedDistance = RangesKt.coerceIn((double)(distance / (this.radius * this.radius)), (double)0.0, (double)1.0);
        double zoomRange = maxZoom - minZoom;
        double t = 1.0 - normalizedDistance;
        return minZoom + (1.0 - t * t * t * t) * zoomRange;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private final void onMove(PlayerMoveEvent event) {
        if (!Intrinsics.areEqual((Object)event.getPlayer().getUniqueId(), (Object)this.player.getUniqueId())) {
            return;
        }
        Location location = event.getTo();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getTo(...)");
        Location location2 = location;
        Double d = ExtensionsKt.distanceSqrt((Location)location2, (Location)this.startLocation);
        double distance = d != null ? d : Double.MAX_VALUE;
        this.updateZoom(distance);
        if (distance < this.radius * this.radius) {
            return;
        }
        this.handleEvent((PlayerEvent)event);
    }

    @EventHandler
    private final void onTeleport(PlayerTeleportEvent event) {
        this.onMove((PlayerMoveEvent)event);
    }

    @Nullable
    public Object teardown(@NotNull Continuation<? super Unit> $completion) {
        if (this.zoom) {
            AttributeInstance attributeInstance = this.player.getAttribute(Attribute.MOVEMENT_SPEED);
            if (attributeInstance != null) {
                attributeInstance.removeModifier((Key)this.key);
            }
        }
        Object object = super.teardown($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public <T extends PlayerEvent> void handleEvent(@NotNull T event) {
        super.handleEvent(event);
    }

    @Nullable
    public Object tick(@NotNull Continuation<? super Unit> $completion) {
        return super.tick($completion);
    }

    @Nullable
    public Object boundStateChange(@NotNull InteractionBoundState previousBoundState, @NotNull InteractionBoundState newBoundState, @NotNull Continuation<? super Unit> $completion) {
        return super.boundStateChange(previousBoundState, newBoundState, $completion);
    }

    @Nullable
    public Object transitionTo(@NotNull InteractionBound bound, @NotNull Continuation<? super Boolean> $completion) {
        return super.transitionTo(bound, $completion);
    }

    @Nullable
    public Object transitionFrom(@NotNull InteractionBound bound, @NotNull Continuation<? super Unit> $completion) {
        return super.transitionFrom(bound, $completion);
    }
}

