/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.core.utils.point.Vector;
import com.typewritermc.core.utils.point.VectorKt;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.EntityActivity;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.TickResult;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.entity.entries.activity.LookCloseActivityKt;
import com.typewritermc.entity.entries.activity.LookDirection;
import com.typewritermc.entity.entries.activity.Velocity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/typewritermc/entity/entries/activity/LookAtBlockActivity;", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "startLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "blockPosition", "Lcom/typewritermc/core/utils/point/Position;", "childActivity", "<init>", "(Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;Lcom/typewritermc/core/utils/point/Position;Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;)V", "yawVelocity", "Lcom/typewritermc/entity/entries/activity/Velocity;", "pitchVelocity", "currentDirection", "Lcom/typewritermc/entity/entries/activity/LookDirection;", "initialize", "", "context", "tick", "Lcom/typewritermc/engine/paper/entry/entity/TickResult;", "dispose", "currentPosition", "getCurrentPosition", "()Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "currentProperties", "", "Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "getCurrentProperties", "()Ljava/util/List;", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nLookAtBlockActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookAtBlockActivity.kt\ncom/typewritermc/entity/entries/activity/LookAtBlockActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n774#2:88\n865#2,2:89\n*S KotlinDebug\n*F\n+ 1 LookAtBlockActivity.kt\ncom/typewritermc/entity/entries/activity/LookAtBlockActivity\n*L\n85#1:88\n85#1:89,2\n*E\n"})
public final class LookAtBlockActivity
implements EntityActivity<ActivityContext> {
    @NotNull
    private final Position blockPosition;
    @NotNull
    private final EntityActivity<ActivityContext> childActivity;
    @NotNull
    private final Velocity yawVelocity;
    @NotNull
    private final Velocity pitchVelocity;
    @NotNull
    private LookDirection currentDirection;

    public LookAtBlockActivity(@NotNull PositionProperty startLocation, @NotNull Position blockPosition, @NotNull EntityActivity<ActivityContext> childActivity) {
        Intrinsics.checkNotNullParameter((Object)startLocation, (String)"startLocation");
        Intrinsics.checkNotNullParameter((Object)blockPosition, (String)"blockPosition");
        Intrinsics.checkNotNullParameter(childActivity, (String)"childActivity");
        this.blockPosition = blockPosition;
        this.childActivity = childActivity;
        this.yawVelocity = new Velocity(0.0f);
        this.pitchVelocity = new Velocity(0.0f);
        this.currentDirection = new LookDirection(startLocation.getYaw(), startLocation.getPitch());
    }

    public void initialize(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.childActivity.initialize(context);
    }

    @NotNull
    public TickResult tick(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PositionProperty npcEyeVector = (PositionProperty)Point.add$default((Point)((Point)this.getCurrentPosition()), (double)0.0, (double)context.getEntityState().getEyeHeight(), (double)0.0, (int)5, null);
        Vector direction = VectorKt.toVector((Point)this.blockPosition.minus((Point)npcEyeVector)).normalize();
        float targetYaw = LookCloseActivityKt.getLookYaw(direction.getX(), direction.getZ());
        float targetPitch = LookCloseActivityKt.getLookPitch(direction.getX(), direction.getY(), direction.getZ());
        Pair pair = LookCloseActivityKt.updateLookDirection$default(this.currentDirection, new LookDirection(targetYaw, targetPitch), this.yawVelocity, this.pitchVelocity, 0.0f, 16, null);
        float yaw = ((Number)pair.component1()).floatValue();
        float pitch = ((Number)pair.component2()).floatValue();
        this.currentDirection = new LookDirection(yaw, pitch);
        return this.childActivity.tick(context);
    }

    public void dispose(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.yawVelocity.setValue(0.0f);
        this.pitchVelocity.setValue(0.0f);
        this.childActivity.dispose(context);
    }

    @NotNull
    public PositionProperty getCurrentPosition() {
        return PositionProperty.copy$default((PositionProperty)this.childActivity.getCurrentPosition(), null, (double)0.0, (double)0.0, (double)0.0, (float)this.currentDirection.getYaw(), (float)this.currentDirection.getPitch(), (int)15, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<EntityProperty> getCurrentProperties() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.childActivity.getCurrentProperties();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EntityProperty it = (EntityProperty)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof PositionProperty))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)this.getCurrentPosition());
    }
}

