/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.extension.annotations.Default;
import com.typewritermc.core.extension.annotations.Entry;
import com.typewritermc.core.extension.annotations.Help;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.EntityActivity;
import com.typewritermc.engine.paper.entry.entity.IndividualActivityContext;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.SharedActivityContext;
import com.typewritermc.engine.paper.entry.entries.EntityActivityEntry;
import com.typewritermc.engine.paper.entry.entries.GenericEntityActivityEntry;
import com.typewritermc.entity.entries.activity.PlayerCloseByActivity;
import java.time.Duration;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Entry(name="player_close_by_activity", description="A player close by activity", color="#3366CC", icon="material-symbols-light:frame-person")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001Bc\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u0012\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J \u0010#\u001a\n\u0012\u0006\b\u0000\u0012\u00020%0$2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0015\u001a\u0004\b\u001c\u0010\u001dR$\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u0015\u001a\u0004\b\u001f\u0010 R$\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u0015\u001a\u0004\b\"\u0010 \u00a8\u0006)"}, d2={"Lcom/typewritermc/entity/entries/activity/PlayerCloseByActivityEntry;", "Lcom/typewritermc/engine/paper/entry/entries/GenericEntityActivityEntry;", "id", "", "name", "range", "", "activationRange", "Ljava/util/Optional;", "maxIdleDuration", "Ljava/time/Duration;", "closeByActivity", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityActivityEntry;", "idleActivity", "<init>", "(Ljava/lang/String;Ljava/lang/String;DLjava/util/Optional;Ljava/time/Duration;Lcom/typewritermc/core/entries/Ref;Lcom/typewritermc/core/entries/Ref;)V", "getId", "()Ljava/lang/String;", "getName", "getRange$annotations", "()V", "getRange", "()D", "getActivationRange$annotations", "getActivationRange", "()Ljava/util/Optional;", "getMaxIdleDuration$annotations", "getMaxIdleDuration", "()Ljava/time/Duration;", "getCloseByActivity$annotations", "getCloseByActivity", "()Lcom/typewritermc/core/entries/Ref;", "getIdleActivity$annotations", "getIdleActivity", "create", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "context", "currentLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nPlayerCloseByActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerCloseByActivity.kt\ncom/typewritermc/entity/entries/activity/PlayerCloseByActivityEntry\n+ 2 EntryReference.kt\ncom/typewritermc/core/entries/EntryReferenceKt\n*L\n1#1,155:1\n6#2:156\n6#2:157\n*S KotlinDebug\n*F\n+ 1 PlayerCloseByActivity.kt\ncom/typewritermc/entity/entries/activity/PlayerCloseByActivityEntry\n*L\n53#1:156\n55#1:157\n*E\n"})
public final class PlayerCloseByActivityEntry
implements GenericEntityActivityEntry {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    private final double range;
    @NotNull
    private final Optional<Double> activationRange;
    @NotNull
    private final Duration maxIdleDuration;
    @NotNull
    private final Ref<? extends EntityActivityEntry> closeByActivity;
    @NotNull
    private final Ref<? extends EntityActivityEntry> idleActivity;

    public PlayerCloseByActivityEntry(@NotNull String id, @NotNull String name, double range, @NotNull Optional<Double> activationRange, @NotNull Duration maxIdleDuration, @NotNull Ref<? extends EntityActivityEntry> closeByActivity, @NotNull Ref<? extends EntityActivityEntry> idleActivity) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(activationRange, (String)"activationRange");
        Intrinsics.checkNotNullParameter((Object)maxIdleDuration, (String)"maxIdleDuration");
        Intrinsics.checkNotNullParameter(closeByActivity, (String)"closeByActivity");
        Intrinsics.checkNotNullParameter(idleActivity, (String)"idleActivity");
        this.id = id;
        this.name = name;
        this.range = range;
        this.activationRange = activationRange;
        this.maxIdleDuration = maxIdleDuration;
        this.closeByActivity = closeByActivity;
        this.idleActivity = idleActivity;
    }

    public /* synthetic */ PlayerCloseByActivityEntry(String string, String string2, double d, Optional optional, Duration duration, Ref ref, Ref ref2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean $i$f$emptyRef;
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            d = 10.0;
        }
        if ((n & 8) != 0) {
            Optional<Double> optional2 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
            optional = optional2;
        }
        if ((n & 0x10) != 0) {
            Duration duration2 = Duration.ofSeconds(30L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 0x20) != 0) {
            $i$f$emptyRef = false;
            ref = new Ref("", Reflection.getOrCreateKotlinClass(EntityActivityEntry.class), null, 4, null);
        }
        if ((n & 0x40) != 0) {
            $i$f$emptyRef = false;
            ref2 = new Ref("", Reflection.getOrCreateKotlinClass(EntityActivityEntry.class), null, 4, null);
        }
        this(string, string2, d, optional, duration, (Ref<? extends EntityActivityEntry>)ref, (Ref<? extends EntityActivityEntry>)ref2);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public final double getRange() {
        return this.range;
    }

    @Help(text="The range in which the player has to be close by to activate the activity.")
    @Default(json="10.0")
    public static /* synthetic */ void getRange$annotations() {
    }

    @NotNull
    public final Optional<Double> getActivationRange() {
        return this.activationRange;
    }

    @Help(text="Optional range in which the player has to enter to activate the activity. Must be smaller than the main range.")
    public static /* synthetic */ void getActivationRange$annotations() {
    }

    @NotNull
    public final Duration getMaxIdleDuration() {
        return this.maxIdleDuration;
    }

    @Help(text="The maximum duration a player can be idle in the same range before the activity deactivates.")
    @Default(json="30000")
    public static /* synthetic */ void getMaxIdleDuration$annotations() {
    }

    @NotNull
    public final Ref<? extends EntityActivityEntry> getCloseByActivity() {
        return this.closeByActivity;
    }

    @Help(text="The activity that will be used when there is a player close by.")
    public static /* synthetic */ void getCloseByActivity$annotations() {
    }

    @NotNull
    public final Ref<? extends EntityActivityEntry> getIdleActivity() {
        return this.idleActivity;
    }

    @Help(text="The activity that will be used when there is no player close by.")
    public static /* synthetic */ void getIdleActivity$annotations() {
    }

    @NotNull
    public EntityActivity<? super ActivityContext> create(@NotNull ActivityContext context, @NotNull PositionProperty currentLocation) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)currentLocation, (String)"currentLocation");
        Double effectiveActivationRange = this.activationRange.map(arg_0 -> PlayerCloseByActivityEntry.create$lambda$1(arg_0 -> PlayerCloseByActivityEntry.create$lambda$0(this, arg_0), arg_0)).orElse(this.range);
        Intrinsics.checkNotNull((Object)effectiveActivationRange);
        return (EntityActivity)new PlayerCloseByActivity(this.range, effectiveActivationRange, this.maxIdleDuration, this.closeByActivity, this.idleActivity, currentLocation);
    }

    @NotNull
    public EntityActivity<SharedActivityContext> create(@NotNull SharedActivityContext context, @NotNull PositionProperty currentLocation) {
        return super.create(context, currentLocation);
    }

    @NotNull
    public EntityActivity<IndividualActivityContext> create(@NotNull IndividualActivityContext context, @NotNull PositionProperty currentLocation) {
        return super.create(context, currentLocation);
    }

    private static final Double create$lambda$0(PlayerCloseByActivityEntry this$0, Double it) {
        Double d;
        if (it >= this$0.range) {
            TypewriterPaperPluginKt.getLogger().warning("The activation range must be smaller than the main range.");
            d = this$0.range;
        } else {
            d = it;
        }
        return d;
    }

    private static final Double create$lambda$1(Function1 $tmp0, Object p0) {
        return (Double)$tmp0.invoke(p0);
    }

    public PlayerCloseByActivityEntry() {
        this(null, null, 0.0, null, null, null, null, 127, null);
    }
}

