/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.GenericEntityActivity;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.TickResult;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.entry.entries.VariableEntryKt;
import com.typewritermc.entity.entries.activity.LookCloseActivityKt;
import com.typewritermc.entity.entries.activity.LookDirection;
import com.typewritermc.entity.entries.activity.RandomLookActivityEntryKt;
import com.typewritermc.entity.entries.activity.Velocity;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/typewritermc/entity/entries/activity/RandomLookActivity;", "Lcom/typewritermc/engine/paper/entry/entity/GenericEntityActivity;", "pitchRange", "Lkotlin/ranges/ClosedRange;", "", "yawRange", "duration", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "Ljava/time/Duration;", "currentPosition", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "<init>", "(Lkotlin/ranges/ClosedRange;Lkotlin/ranges/ClosedRange;Lcom/typewritermc/engine/paper/entry/entries/Var;Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "getCurrentPosition", "()Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "setCurrentPosition", "(Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "targetPitch", "targetYaw", "pitchVelocity", "Lcom/typewritermc/entity/entries/activity/Velocity;", "yawVelocity", "nextChangeTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "initialize", "", "context", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "tick", "Lcom/typewritermc/engine/paper/entry/entity/TickResult;", "dispose", "EntityExtension"})
public final class RandomLookActivity
implements GenericEntityActivity {
    @NotNull
    private final ClosedRange<Float> pitchRange;
    @NotNull
    private final ClosedRange<Float> yawRange;
    @NotNull
    private final Var<Duration> duration;
    @NotNull
    private PositionProperty currentPosition;
    private float targetPitch;
    private float targetYaw;
    @NotNull
    private final Velocity pitchVelocity;
    @NotNull
    private final Velocity yawVelocity;
    private Instant nextChangeTime;

    public RandomLookActivity(@NotNull ClosedRange<Float> pitchRange, @NotNull ClosedRange<Float> yawRange, @NotNull Var<Duration> duration, @NotNull PositionProperty currentPosition) {
        Intrinsics.checkNotNullParameter(pitchRange, (String)"pitchRange");
        Intrinsics.checkNotNullParameter(yawRange, (String)"yawRange");
        Intrinsics.checkNotNullParameter(duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)currentPosition, (String)"currentPosition");
        this.pitchRange = pitchRange;
        this.yawRange = yawRange;
        this.duration = duration;
        this.currentPosition = currentPosition;
        this.targetPitch = RandomLookActivityEntryKt.random(this.pitchRange);
        this.targetYaw = RandomLookActivityEntryKt.random(this.yawRange);
        this.pitchVelocity = new Velocity(0.0f);
        this.yawVelocity = new Velocity(0.0f);
        this.nextChangeTime = Instant.now();
    }

    @NotNull
    public PositionProperty getCurrentPosition() {
        return this.currentPosition;
    }

    public void setCurrentPosition(@NotNull PositionProperty positionProperty) {
        Intrinsics.checkNotNullParameter((Object)positionProperty, (String)"<set-?>");
        this.currentPosition = positionProperty;
    }

    public void initialize(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    @NotNull
    public TickResult tick(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Instant currentTime = Instant.now();
        if (currentTime.compareTo(this.nextChangeTime) > 0) {
            this.targetPitch = RandomLookActivityEntryKt.random(this.pitchRange);
            this.targetYaw = RandomLookActivityEntryKt.random(this.yawRange);
            Duration duration = (Duration)VariableEntryKt.get$default(this.duration, (Player)context.getRandomViewer(), null, (int)2, null);
            if (duration == null) {
                duration = Duration.ofSeconds(1L);
            }
            Duration duration2 = duration;
            this.nextChangeTime = currentTime.plus(duration2);
        }
        Pair<Float, Float> pair = LookCloseActivityKt.updateLookDirection(new LookDirection(this.getCurrentPosition().getYaw(), this.getCurrentPosition().getPitch()), new LookDirection(this.targetYaw, this.targetPitch), this.yawVelocity, this.pitchVelocity, 0.5f);
        float yaw = ((Number)pair.component1()).floatValue();
        float pitch = ((Number)pair.component2()).floatValue();
        this.setCurrentPosition(new PositionProperty(this.getCurrentPosition().getWorld(), this.getCurrentPosition().getX(), this.getCurrentPosition().getY(), this.getCurrentPosition().getZ(), yaw, pitch));
        return TickResult.CONSUMED;
    }

    public void dispose(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    @NotNull
    public List<EntityProperty> getCurrentProperties() {
        return super.getCurrentProperties();
    }
}

