/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.core.utils.point.PositionKt;
import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.EntityActivity;
import com.typewritermc.engine.paper.entry.entity.IdleActivity;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.TickResult;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.entity.entries.activity.NavigationActivity;
import com.typewritermc.roadnetwork.RoadNetwork;
import com.typewritermc.roadnetwork.RoadNetworkEntry;
import com.typewritermc.roadnetwork.RoadNetworkManager;
import com.typewritermc.roadnetwork.RoadNode;
import com.typewritermc.roadnetwork.gps.GPS;
import com.typewritermc.roadnetwork.gps.PointToPointGPS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.java.KoinJavaComponent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/typewritermc/entity/entries/activity/RandomPatrolActivity;", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "Lorg/koin/core/component/KoinComponent;", "roadNetwork", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/roadnetwork/RoadNetworkEntry;", "radiusSquared", "", "startLocation", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "<init>", "(Lcom/typewritermc/core/entries/Ref;DLcom/typewritermc/engine/paper/entry/entity/PositionProperty;)V", "network", "Lcom/typewritermc/roadnetwork/RoadNetwork;", "activity", "refreshActivity", "Lcom/typewritermc/engine/paper/entry/entity/TickResult;", "context", "initialize", "", "setup", "tick", "dispose", "currentPosition", "getCurrentPosition", "()Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "currentProperties", "", "Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "getCurrentProperties", "()Ljava/util/List;", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nRandomPatrolActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RandomPatrolActivity.kt\ncom/typewritermc/entity/entries/activity/RandomPatrolActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n774#2:109\n865#2,2:110\n*S KotlinDebug\n*F\n+ 1 RandomPatrolActivity.kt\ncom/typewritermc/entity/entries/activity/RandomPatrolActivity\n*L\n56#1:109\n56#1:110,2\n*E\n"})
public final class RandomPatrolActivity
implements EntityActivity<ActivityContext>,
KoinComponent {
    @NotNull
    private final Ref<RoadNetworkEntry> roadNetwork;
    private final double radiusSquared;
    @Nullable
    private RoadNetwork network;
    @NotNull
    private EntityActivity<? super ActivityContext> activity;

    public RandomPatrolActivity(@NotNull Ref<RoadNetworkEntry> roadNetwork, double radiusSquared, @NotNull PositionProperty startLocation) {
        Intrinsics.checkNotNullParameter(roadNetwork, (String)"roadNetwork");
        Intrinsics.checkNotNullParameter((Object)startLocation, (String)"startLocation");
        this.roadNetwork = roadNetwork;
        this.radiusSquared = radiusSquared;
        this.activity = (EntityActivity)new IdleActivity(startLocation);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TickResult refreshActivity(@NotNull ActivityContext context, @NotNull RoadNetwork network) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Position currentPos = this.getCurrentPosition().toPosition();
        Iterable iterable = network.getNodes();
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RoadNode it = (RoadNode)element$iv$iv;
            boolean bl = false;
            Double d = PositionKt.distanceSqrt((Point)((Point)it.getPosition()), (Point)((Point)currentPos));
            if (!((d != null ? d : Double.MAX_VALUE) <= this.radiusSquared)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        RoadNode roadNode = (RoadNode)CollectionsKt.randomOrNull((Collection)((List)destination$iv$iv), (Random)((Random)Random.Default));
        if (roadNode == null) {
            return TickResult.IGNORED;
        }
        RoadNode nextNode = roadNode;
        this.activity.dispose(context);
        this.activity = (EntityActivity)new NavigationActivity((GPS)new PointToPointGPS(this.roadNetwork, (Function2)new Function2<RoadNetwork, Continuation<? super Position>, Object>(this, null){
            int label;
            final /* synthetic */ RandomPatrolActivity this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return this.this$0.getCurrentPosition().toPosition();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(RoadNetwork p1, Continuation<? super Position> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function2)new Function2<RoadNetwork, Continuation<? super Position>, Object>(nextNode, null){
            int label;
            final /* synthetic */ RoadNode $nextNode;
            {
                this.$nextNode = $nextNode;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return this.$nextNode.getPosition();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(RoadNetwork p1, Continuation<? super Position> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), this.getCurrentPosition());
        this.activity.initialize(context);
        return TickResult.CONSUMED;
    }

    public void initialize(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.setup(context);
    }

    private final void setup(ActivityContext context) {
        RoadNetwork roadNetwork = ((RoadNetworkManager)KoinJavaComponent.get$default(RoadNetworkManager.class, null, null, (int)6, null)).getNetworkOrNull(this.roadNetwork);
        if (roadNetwork == null) {
            return;
        }
        RoadNetwork roadNetwork2 = this.network = roadNetwork;
        Intrinsics.checkNotNull((Object)roadNetwork2);
        this.refreshActivity(context, roadNetwork2);
    }

    @NotNull
    public TickResult tick(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.network == null) {
            this.setup(context);
            return TickResult.CONSUMED;
        }
        TickResult result = this.activity.tick(context);
        if (result == TickResult.IGNORED) {
            RoadNetwork roadNetwork = this.network;
            Intrinsics.checkNotNull((Object)roadNetwork);
            return this.refreshActivity(context, roadNetwork);
        }
        return TickResult.CONSUMED;
    }

    public void dispose(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PositionProperty oldPosition = this.getCurrentPosition();
        this.activity.dispose(context);
        this.activity = (EntityActivity)new IdleActivity(oldPosition);
    }

    @NotNull
    public PositionProperty getCurrentPosition() {
        return this.activity.getCurrentPosition();
    }

    @NotNull
    public List<EntityProperty> getCurrentProperties() {
        return this.activity.getCurrentProperties();
    }

    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin((KoinComponent)this);
    }
}

