/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.activity;

import com.typewritermc.engine.paper.entry.entity.ActivityContext;
import com.typewritermc.engine.paper.entry.entity.EntityActivity;
import com.typewritermc.engine.paper.entry.entity.PositionProperty;
import com.typewritermc.engine.paper.entry.entity.TickResult;
import com.typewritermc.engine.paper.entry.entries.EntityProperty;
import com.typewritermc.engine.paper.entry.entries.Var;
import com.typewritermc.engine.paper.entry.entries.VariableEntryKt;
import com.typewritermc.entity.entries.activity.SpinAxis;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/typewritermc/entity/entries/activity/SpinActivity;", "Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;", "Lcom/typewritermc/engine/paper/entry/entity/ActivityContext;", "duration", "Lcom/typewritermc/engine/paper/entry/entries/Var;", "Ljava/time/Duration;", "clockwise", "", "axis", "Lcom/typewritermc/entity/entries/activity/SpinAxis;", "childActivity", "<init>", "(Lcom/typewritermc/engine/paper/entry/entries/Var;ZLcom/typewritermc/entity/entries/activity/SpinAxis;Lcom/typewritermc/engine/paper/entry/entity/EntityActivity;)V", "startTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "startRotation", "", "direction", "", "currentRotation", "initialize", "", "context", "tick", "Lcom/typewritermc/engine/paper/entry/entity/TickResult;", "dispose", "currentPosition", "Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "getCurrentPosition", "()Lcom/typewritermc/engine/paper/entry/entity/PositionProperty;", "currentProperties", "", "Lcom/typewritermc/engine/paper/entry/entries/EntityProperty;", "getCurrentProperties", "()Ljava/util/List;", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nSpinActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpinActivity.kt\ncom/typewritermc/entity/entries/activity/SpinActivity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n774#2:99\n865#2,2:100\n*S KotlinDebug\n*F\n+ 1 SpinActivity.kt\ncom/typewritermc/entity/entries/activity/SpinActivity\n*L\n97#1:99\n97#1:100,2\n*E\n"})
public final class SpinActivity
implements EntityActivity<ActivityContext> {
    @NotNull
    private final Var<Duration> duration;
    @NotNull
    private final SpinAxis axis;
    @NotNull
    private final EntityActivity<ActivityContext> childActivity;
    private Instant startTime;
    private float startRotation;
    private final int direction;
    private float currentRotation;

    public SpinActivity(@NotNull Var<Duration> duration, boolean clockwise, @NotNull SpinAxis axis, @NotNull EntityActivity<ActivityContext> childActivity) {
        Intrinsics.checkNotNullParameter(duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        Intrinsics.checkNotNullParameter(childActivity, (String)"childActivity");
        this.duration = duration;
        this.axis = axis;
        this.childActivity = childActivity;
        this.startTime = Instant.now();
        this.direction = clockwise ? -1 : 1;
    }

    public void initialize(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.startTime = Instant.now();
        this.childActivity.initialize(context);
        this.currentRotation = this.startRotation = (switch (WhenMappings.$EnumSwitchMapping$0[this.axis.ordinal()]) {
            case 1 -> this.childActivity.getCurrentPosition().getYaw();
            case 2 -> this.childActivity.getCurrentPosition().getPitch();
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    @NotNull
    public TickResult tick(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Duration duration = (Duration)VariableEntryKt.get$default(this.duration, (Player)context.getRandomViewer(), null, (int)2, null);
        if (duration == null) {
            duration = Duration.ofSeconds(2L);
        }
        Duration rotationDuration = duration;
        Duration elapsed = Duration.between(this.startTime, Instant.now());
        float progress = (float)(elapsed.toMillis() % rotationDuration.toMillis()) / (float)rotationDuration.toMillis();
        float angle = progress * (float)360 * (float)this.direction;
        this.currentRotation = this.startRotation + (switch (WhenMappings.$EnumSwitchMapping$0[this.axis.ordinal()]) {
            case 1 -> ((angle + (float)180) % (float)360 + (float)360) % (float)360 - (float)180;
            case 2 -> {
                double radians = Math.toRadians(angle);
                yield 90.0f * (float)Math.sin(radians);
            }
            default -> throw new NoWhenBranchMatchedException();
        });
        return this.childActivity.tick(context);
    }

    public void dispose(@NotNull ActivityContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.childActivity.dispose(context);
    }

    @NotNull
    public PositionProperty getCurrentPosition() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.axis.ordinal()]) {
            case 1 -> PositionProperty.copy$default((PositionProperty)this.childActivity.getCurrentPosition(), null, (double)0.0, (double)0.0, (double)0.0, (float)this.currentRotation, (float)0.0f, (int)47, null);
            case 2 -> PositionProperty.copy$default((PositionProperty)this.childActivity.getCurrentPosition(), null, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)this.currentRotation, (int)31, null);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<EntityProperty> getCurrentProperties() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.childActivity.getCurrentProperties();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EntityProperty it = (EntityProperty)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof PositionProperty))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)this.getCurrentPosition());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpinAxis.values().length];
            try {
                nArray[SpinAxis.YAW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpinAxis.PITCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

