/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.bound;

import com.typewritermc.core.entries.Ref;
import com.typewritermc.core.interaction.InteractionBound;
import com.typewritermc.core.interaction.InteractionBoundState;
import com.typewritermc.core.interaction.InteractionContextKey;
import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Vector;
import com.typewritermc.core.utils.point.VectorKt;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.entry.AudienceManager;
import com.typewritermc.engine.paper.entry.entity.AudienceEntityDisplay;
import com.typewritermc.engine.paper.entry.entries.EntityInstanceEntry;
import com.typewritermc.engine.paper.entry.entries.EventTrigger;
import com.typewritermc.engine.paper.interaction.ListenerInteractionBound;
import com.typewritermc.engine.paper.interaction.PlayerSessionKt;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import com.typewritermc.engine.paper.utils.PointKt;
import com.typewritermc.entity.entries.activity.LookCloseActivityKt;
import com.typewritermc.entity.entries.activity.LookDirection;
import com.typewritermc.entity.entries.activity.Velocity;
import com.typewritermc.entity.entries.bound.AnimationState;
import com.typewritermc.entity.entries.bound.LookAtNpcInteractionBound;
import com.typewritermc.entity.entries.event.InteractingEntityInstance;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.java.KoinJavaComponent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u001a\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0003J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020$H\u0003J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0003J\u000e\u0010-\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010.\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/typewritermc/entity/entries/bound/LookAtNpcInteractionBound;", "Lcom/typewritermc/engine/paper/interaction/ListenerInteractionBound;", "player", "Lorg/bukkit/entity/Player;", "radius", "", "instanceEntryRef", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/EntityInstanceEntry;", "priority", "", "interruptionTriggers", "", "Lcom/typewritermc/engine/paper/entry/entries/EventTrigger;", "<init>", "(Lorg/bukkit/entity/Player;DLcom/typewritermc/core/entries/Ref;ILjava/util/List;)V", "getPriority", "()I", "getInterruptionTriggers", "()Ljava/util/List;", "startLocation", "Lorg/bukkit/Location;", "Lorg/jetbrains/annotations/NotNull;", "key", "Lorg/bukkit/NamespacedKey;", "Lorg/jetbrains/annotations/Nullable;", "initialize", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateZoom", "distance", "calculateZoom", "onMove", "event", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "yawVelocity", "Lcom/typewritermc/entity/entries/activity/Velocity;", "pitchVelocity", "state", "Lcom/typewritermc/entity/entries/bound/AnimationState;", "animationThreshold", "", "onLook", "tick", "teardown", "EntityExtension"})
public final class LookAtNpcInteractionBound
implements ListenerInteractionBound {
    @NotNull
    private final Player player;
    private final double radius;
    @NotNull
    private final Ref<? extends EntityInstanceEntry> instanceEntryRef;
    private final int priority;
    @NotNull
    private final List<EventTrigger> interruptionTriggers;
    @NotNull
    private final Location startLocation;
    @NotNull
    private final NamespacedKey key;
    @NotNull
    private final Velocity yawVelocity;
    @NotNull
    private final Velocity pitchVelocity;
    @NotNull
    private AnimationState state;
    private final float animationThreshold;

    public LookAtNpcInteractionBound(@NotNull Player player, double radius, @NotNull Ref<? extends EntityInstanceEntry> instanceEntryRef, int priority, @NotNull List<? extends EventTrigger> interruptionTriggers) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(instanceEntryRef, (String)"instanceEntryRef");
        Intrinsics.checkNotNullParameter(interruptionTriggers, (String)"interruptionTriggers");
        this.player = player;
        this.radius = radius;
        this.instanceEntryRef = instanceEntryRef;
        this.priority = priority;
        this.interruptionTriggers = interruptionTriggers;
        Location location = this.player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        this.startLocation = location;
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)"zoom", (Plugin)((Plugin)TypewriterPaperPluginKt.getPlugin()));
        Intrinsics.checkNotNull((Object)namespacedKey);
        this.key = namespacedKey;
        this.yawVelocity = new Velocity(0.0f);
        this.pitchVelocity = new Velocity(0.0f);
        this.state = AnimationState.Animating.INSTANCE;
        this.animationThreshold = 0.5f;
    }

    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public List<EventTrigger> getInterruptionTriggers() {
        return this.interruptionTriggers;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object initialize(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof initialize.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ LookAtNpcInteractionBound this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.initialize((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = super.initialize((Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                this.updateZoom(0.0);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void updateZoom(double distance) {
        block0: {
            double zoom = this.calculateZoom(distance);
            AttributeModifier modifier = new AttributeModifier(this.key, zoom, AttributeModifier.Operation.MULTIPLY_SCALAR_1);
            AttributeInstance attributeInstance = this.player.getAttribute(Attribute.MOVEMENT_SPEED);
            if (attributeInstance == null) break block0;
            AttributeInstance attribute = attributeInstance;
            boolean bl = false;
            attribute.removeModifier((Key)this.key);
            attribute.addModifier(modifier);
        }
    }

    private final double calculateZoom(double distance) {
        double minZoom = -0.6;
        double maxZoom = 0.0;
        double normalizedDistance = RangesKt.coerceIn((double)(distance / (this.radius * this.radius)), (double)0.0, (double)1.0);
        double zoomRange = maxZoom - minZoom;
        double t = 1.0 - normalizedDistance;
        return minZoom + (1.0 - t * t * t * t) * zoomRange;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private final void onMove(PlayerMoveEvent event) {
        if (!Intrinsics.areEqual((Object)event.getPlayer().getUniqueId(), (Object)this.player.getUniqueId())) {
            return;
        }
        Location location = event.getTo();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getTo(...)");
        Location location2 = location;
        Double d = ExtensionsKt.distanceSqrt((Location)location2, (Location)this.startLocation);
        double distance = d != null ? d : Double.MAX_VALUE;
        this.updateZoom(distance);
        if (distance < this.radius * this.radius) {
            return;
        }
        this.handleEvent((PlayerEvent)event);
    }

    @EventHandler
    private final void onTeleport(PlayerTeleportEvent event) {
        this.onMove((PlayerMoveEvent)event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private final void onLook(PlayerMoveEvent event) {
        if (!Intrinsics.areEqual((Object)event.getPlayer().getUniqueId(), (Object)this.player.getUniqueId())) {
            return;
        }
        if (!event.hasChangedOrientation() && !event.hasExplicitlyChangedPosition()) {
            return;
        }
        if (this.state.isAnimating()) {
            return;
        }
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.state = new AnimationState.Moved(instant);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object tick(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof tick.1)) ** GOTO lbl-1000
        var20_2 = $completion;
        if ((var20_2.label & -2147483648) != 0) {
            var20_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ LookAtNpcInteractionBound this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.tick((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = super.tick((Continuation)$continuation);
                if (v0 == var21_4) {
                    return var21_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                this.state = this.state.transition();
                if (!this.state.isAnimating()) {
                    return Unit.INSTANCE;
                }
                v1 = PlayerSessionKt.getInteractionContext((Player)this.player);
                if (v1 == null) {
                    return Unit.INSTANCE;
                }
                context = v1;
                if (this.instanceEntryRef.isSet()) {
                    v2 = this.instanceEntryRef;
                } else {
                    var5_6 = context.get((InteractionContextKey)InteractingEntityInstance.INSTANCE);
                    v2 = var5_6 instanceof Ref != false ? (Ref)var5_6 : null;
                    if (v2 == null) {
                        return Unit.INSTANCE;
                    }
                }
                ref = v2;
                var6_8 = ((AudienceManager)KoinJavaComponent.get$default(AudienceManager.class, null, null, (int)6, null)).get(ref);
                v3 = var6_8 instanceof AudienceEntityDisplay != false ? (AudienceEntityDisplay)var6_8 : null;
                if (v3 == null) {
                    return Unit.INSTANCE;
                }
                display = v3;
                v4 = this.player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getUniqueId(...)");
                if (!display.isSpawnedIn(v4)) {
                    this.state = AnimationState.Idle.INSTANCE;
                    this.yawVelocity.setValue(0.0f);
                    this.pitchVelocity.setValue(0.0f);
                    return Unit.INSTANCE;
                }
                v5 = this.player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getUniqueId(...)");
                entityState = display.entityState(v5);
                v6 = this.player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getUniqueId(...)");
                position = display.position(v6);
                v7 = position;
                if (v7 == null || (v7 = v7.add(0.0, entityState.getEyeHeight(), 0.0)) == null) {
                    return Unit.INSTANCE;
                }
                target = v7;
                v8 = this.player.getEyeLocation();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getEyeLocation(...)");
                playerEyePosition = PointKt.toPosition((Location)v8);
                direction = ((Vector)VectorKt.toVector((Point)((Point)target)).minus((Point)playerEyePosition)).normalize();
                targetYaw = LookCloseActivityKt.getLookYaw(direction.getX(), direction.getZ());
                targetPitch = LookCloseActivityKt.getLookPitch(direction.getX(), direction.getY(), direction.getZ());
                var12_15 = LookCloseActivityKt.updateLookDirection(new LookDirection(playerEyePosition.getYaw(), playerEyePosition.getPitch()), new LookDirection(targetYaw, targetPitch), this.yawVelocity, this.pitchVelocity, 0.2f);
                newYaw = ((Number)var12_15.component1()).floatValue();
                newPitch = ((Number)var12_15.component2()).floatValue();
                var16_20 = var15_18 = this.player.getLocation().clone();
                var18_22 = this.player;
                $i$a$-apply-LookAtNpcInteractionBound$tick$2 = false;
                $this$tick_u24lambda_u241.setYaw(newYaw);
                $this$tick_u24lambda_u241.setPitch(newPitch);
                var18_22.teleportAsync(var15_18);
                yawDiff = Math.abs(LookCloseActivityKt.normalizeYaw(targetYaw - newYaw));
                pitchDiff = Math.abs(targetPitch - newPitch);
                if (yawDiff < this.animationThreshold && pitchDiff < this.animationThreshold) {
                    this.state = AnimationState.Idle.INSTANCE;
                    this.yawVelocity.setValue(0.0f);
                    this.pitchVelocity.setValue(0.0f);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object teardown(@NotNull Continuation<? super Unit> $completion) {
        AttributeInstance attributeInstance = this.player.getAttribute(Attribute.MOVEMENT_SPEED);
        if (attributeInstance != null) {
            attributeInstance.removeModifier((Key)this.key);
        }
        Object object = super.teardown($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public <T extends PlayerEvent> void handleEvent(@NotNull T event) {
        super.handleEvent(event);
    }

    @Nullable
    public Object boundStateChange(@NotNull InteractionBoundState previousBoundState, @NotNull InteractionBoundState newBoundState, @NotNull Continuation<? super Unit> $completion) {
        return super.boundStateChange(previousBoundState, newBoundState, $completion);
    }

    @Nullable
    public Object transitionTo(@NotNull InteractionBound bound, @NotNull Continuation<? super Boolean> $completion) {
        return super.transitionTo(bound, $completion);
    }

    @Nullable
    public Object transitionFrom(@NotNull InteractionBound bound, @NotNull Continuation<? super Unit> $completion) {
        return super.transitionFrom(bound, $completion);
    }
}

