/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.entity.entries.cinematic;

import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.ServerBoundPacket;
import com.github.retrooper.packetevents.protocol.player.DiggingAction;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import com.typewritermc.core.utils.point.Coordinate;
import com.typewritermc.core.utils.point.Point;
import com.typewritermc.engine.paper.content.ContentContext;
import com.typewritermc.engine.paper.content.modes.RecordingCinematicContentMode;
import com.typewritermc.engine.paper.extensions.packetevents.ArmSwing;
import com.typewritermc.engine.paper.interaction.InterceptionBundle;
import com.typewritermc.engine.paper.interaction.PacketInterceptorKt;
import com.typewritermc.engine.paper.utils.PointKt;
import com.typewritermc.entity.entries.cinematic.EntityFrame;
import com.typewritermc.entity.entries.data.minecraft.PoseDataKt;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u001e\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0002H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/typewritermc/entity/entries/cinematic/EntityCinematicRecording;", "Lcom/typewritermc/engine/paper/content/modes/RecordingCinematicContentMode;", "Lcom/typewritermc/entity/entries/cinematic/EntityFrame;", "context", "Lcom/typewritermc/engine/paper/content/ContentContext;", "player", "Lorg/bukkit/entity/Player;", "klass", "Lkotlin/reflect/KClass;", "initialFrame", "", "<init>", "(Lcom/typewritermc/engine/paper/content/ContentContext;Lorg/bukkit/entity/Player;Lkotlin/reflect/KClass;I)V", "swing", "Lcom/typewritermc/engine/paper/extensions/packetevents/ArmSwing;", "damaged", "", "useItem", "interceptionBundle", "Lcom/typewritermc/engine/paper/interaction/InterceptionBundle;", "initialize", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "onArmSwing", "event", "Lio/papermc/paper/event/player/PlayerArmSwingEvent;", "onPlayerDamaged", "Lorg/bukkit/event/entity/EntityDamageEvent;", "addSwing", "captureFrame", "applyState", "value", "EntityExtension"})
@SourceDebugExtension(value={"SMAP\nEntityCinematicEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityCinematicEntry.kt\ncom/typewritermc/entity/entries/cinematic/EntityCinematicRecording\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,436:1\n1#2:437\n*E\n"})
public final class EntityCinematicRecording
extends RecordingCinematicContentMode<EntityFrame> {
    @Nullable
    private ArmSwing swing;
    private boolean damaged;
    private boolean useItem;
    @Nullable
    private InterceptionBundle interceptionBundle;

    public EntityCinematicRecording(@NotNull ContentContext context, @NotNull Player player, @NotNull KClass<EntityFrame> klass, int initialFrame) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        super(context, player, klass, initialFrame);
    }

    @Nullable
    public Object initialize(@NotNull Continuation<? super Unit> $completion) {
        this.interceptionBundle = PacketInterceptorKt.interceptPackets((Player)this.getPlayer(), arg_0 -> EntityCinematicRecording.initialize$lambda$2(this, arg_0));
        Object object = super.initialize($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object dispose(@NotNull Continuation<? super Unit> $completion) {
        InterceptionBundle interceptionBundle = this.interceptionBundle;
        if (interceptionBundle != null) {
            interceptionBundle.cancel();
        }
        this.interceptionBundle = null;
        Object object = super.dispose($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @EventHandler
    public final void onArmSwing(@NotNull PlayerArmSwingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getPlayer().getUniqueId(), (Object)this.getPlayer().getUniqueId())) {
            return;
        }
        this.getPlayer().getMainHand();
        Pair pair = TuplesKt.to((Object)event.getHand(), (Object)this.getPlayer().getMainHand());
        this.addSwing(Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)EquipmentSlot.HAND, (Object)MainHand.RIGHT)) ? ArmSwing.RIGHT : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)EquipmentSlot.HAND, (Object)MainHand.LEFT)) ? ArmSwing.LEFT : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)EquipmentSlot.OFF_HAND, (Object)MainHand.RIGHT)) ? ArmSwing.LEFT : (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)EquipmentSlot.OFF_HAND, (Object)MainHand.LEFT)) ? ArmSwing.RIGHT : ArmSwing.BOTH))));
    }

    @EventHandler
    public final void onPlayerDamaged(@NotNull EntityDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getEntity().getUniqueId(), (Object)this.getPlayer().getUniqueId())) {
            return;
        }
        this.damaged = true;
    }

    private final void addSwing(ArmSwing swing) {
        if (this.swing != null && this.swing != swing) {
            this.swing = ArmSwing.BOTH;
            return;
        }
        this.swing = swing;
    }

    @NotNull
    public EntityFrame captureFrame() {
        Pose pose;
        PlayerInventory playerInventory = this.getPlayer().getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)playerInventory, (String)"getInventory(...)");
        PlayerInventory inv = playerInventory;
        if (this.getPlayer().isInsideVehicle()) {
            pose = Pose.SITTING;
        } else {
            Pose pose2 = this.getPlayer().getPose();
            pose = pose2;
            Intrinsics.checkNotNullExpressionValue((Object)pose2, (String)"getPose(...)");
        }
        Pose pose3 = pose;
        Location location = this.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        ItemStack itemStack = inv.getHelmet();
        ItemStack itemStack2 = inv.getChestplate();
        ItemStack itemStack3 = inv.getLeggings();
        ItemStack itemStack4 = inv.getBoots();
        EntityFrame data = new EntityFrame(PointKt.toCoordinate((Location)location), PoseDataKt.toEntityPose(pose3), this.swing, this.damaged, this.useItem, inv.getItemInMainHand().clone(), inv.getItemInOffHand().clone(), (ItemStack)(itemStack != null ? itemStack.clone() : null), (ItemStack)(itemStack2 != null ? itemStack2.clone() : null), (ItemStack)(itemStack3 != null ? itemStack3.clone() : null), (ItemStack)(itemStack4 != null ? itemStack4.clone() : null));
        this.swing = null;
        this.damaged = false;
        return data;
    }

    public void applyState(@NotNull EntityFrame value) {
        block18: {
            Coordinate it;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Coordinate coordinate = value.getLocation();
            if (coordinate != null) {
                it = coordinate;
                boolean bl = false;
                Player player = this.getPlayer();
                Point point = (Point)it;
                World world = this.getPlayer().getWorld();
                Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
                player.teleport(PointKt.toBukkitLocation((Point)point, (World)world));
            }
            EntityPose entityPose = value.getPose();
            if (entityPose != null) {
                it = entityPose;
                boolean bl = false;
                this.getPlayer().setPose(PoseDataKt.toBukkitPose((EntityPose)it));
            }
            ArmSwing armSwing = value.getSwing();
            if (armSwing != null) {
                ArmSwing swing = armSwing;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)swing, (Object)this.getPlayer().getMainHand());
                if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)ArmSwing.RIGHT, (Object)MainHand.RIGHT))) {
                    this.getPlayer().swingMainHand();
                } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)ArmSwing.RIGHT, (Object)MainHand.LEFT))) {
                    this.getPlayer().swingOffHand();
                } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)ArmSwing.LEFT, (Object)MainHand.RIGHT))) {
                    this.getPlayer().swingOffHand();
                } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)ArmSwing.LEFT, (Object)MainHand.LEFT))) {
                    this.getPlayer().swingOffHand();
                } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)ArmSwing.BOTH, (Object)MainHand.RIGHT)) || Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)ArmSwing.BOTH, (Object)MainHand.LEFT))) {
                    this.getPlayer().swingMainHand();
                    this.getPlayer().swingOffHand();
                }
            }
            if (Intrinsics.areEqual((Object)value.getDamaged(), (Object)true)) {
                this.getPlayer().damage(0.0);
            }
            ItemStack itemStack = value.getMainHand();
            if (itemStack != null) {
                it = itemStack;
                boolean bl = false;
                this.getPlayer().getInventory().setItemInMainHand((ItemStack)it);
            }
            ItemStack itemStack2 = value.getOffHand();
            if (itemStack2 != null) {
                it = itemStack2;
                boolean bl = false;
                this.getPlayer().getInventory().setItemInOffHand((ItemStack)it);
            }
            ItemStack itemStack3 = value.getHelmet();
            if (itemStack3 != null) {
                it = itemStack3;
                boolean bl = false;
                this.getPlayer().getInventory().setHelmet((ItemStack)it);
            }
            ItemStack itemStack4 = value.getChestplate();
            if (itemStack4 != null) {
                it = itemStack4;
                boolean bl = false;
                this.getPlayer().getInventory().setChestplate((ItemStack)it);
            }
            ItemStack itemStack5 = value.getLeggings();
            if (itemStack5 != null) {
                it = itemStack5;
                boolean bl = false;
                this.getPlayer().getInventory().setLeggings((ItemStack)it);
            }
            ItemStack itemStack6 = value.getBoots();
            if (itemStack6 == null) break block18;
            it = itemStack6;
            boolean bl = false;
            this.getPlayer().getInventory().setBoots((ItemStack)it);
        }
    }

    private static final Unit initialize$lambda$2$lambda$0(EntityCinematicRecording this$0, PacketReceiveEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.useItem = true;
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$2$lambda$1(EntityCinematicRecording this$0, PacketReceiveEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WrapperPlayClientPlayerDigging packet = new WrapperPlayClientPlayerDigging(it);
        if (packet.getAction() != DiggingAction.RELEASE_USE_ITEM) {
            return Unit.INSTANCE;
        }
        this$0.useItem = false;
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$2(EntityCinematicRecording this$0, InterceptionBundle $this$interceptPackets) {
        Intrinsics.checkNotNullParameter((Object)$this$interceptPackets, (String)"$this$interceptPackets");
        $this$interceptPackets.invoke((ServerBoundPacket)PacketType.Play.Client.USE_ITEM, arg_0 -> EntityCinematicRecording.initialize$lambda$2$lambda$0(this$0, arg_0));
        $this$interceptPackets.invoke((ServerBoundPacket)PacketType.Play.Client.PLAYER_DIGGING, arg_0 -> EntityCinematicRecording.initialize$lambda$2$lambda$1(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

