/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import com.extollit.collect.AdapterIterable;
import com.extollit.collect.CollectionsExt;
import com.extollit.collect.CombinationsIterator;
import com.extollit.collect.FlattenIterable;
import com.extollit.collect.PermutationsIterator;
import com.extollit.tuple.SymmetricPair;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Combinations<T> {
    private final Iterable<T> delegate;

    public Combinations(Iterable<T> delegate) {
        this.delegate = delegate;
    }

    public Iterable<List<T>> tupleCombinations(final int tupleSize) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new CombinationsIterator(Combinations.this.delegate, tupleSize);
            }
        };
    }

    public Iterable<SymmetricPair.Sealed<T>> pairCombinations() {
        return new Iterable<SymmetricPair.Sealed<T>>(){

            @Override
            public Iterator<SymmetricPair.Sealed<T>> iterator() {
                return new AdapterIterable.AdapterIterator<SymmetricPair.Sealed<T>, List<T>>(new CombinationsIterator(Combinations.this.delegate, 2)){

                    @Override
                    protected SymmetricPair.Sealed<T> map(List<T> input) {
                        Iterator i = input.iterator();
                        return SymmetricPair.Sealed.combination(i.next(), i.next());
                    }
                };
            }
        };
    }

    public Iterable<List<T>> powerSet() {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new FlattenIterable.Iter(new PowerSetIter(false));
            }
        };
    }

    public Iterable<List<T>> reversePowerSet() {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new FlattenIterable.Iter(new PowerSetIter(true));
            }
        };
    }

    public Iterable<List<T>> powerSet(final int limit) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new FlattenIterable.Iter(new PowerSetIter(false, limit));
            }
        };
    }

    public Iterable<List<T>> reversePowerSet(final int limit) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new FlattenIterable.Iter(new PowerSetIter(true, limit));
            }
        };
    }

    public static <T> Iterable<List<T>> permute(final Iterable<T> combination) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new PermutationsIterator(combination);
            }
        };
    }

    private class PowerSetIter
    implements Iterator<Iterable<List<T>>> {
        private final boolean reverse;
        private final List<T> delegate;
        private final int limit;
        private int currentRank = 0;

        private PowerSetIter(boolean reverse) {
            this(reverse, Integer.MAX_VALUE);
        }

        private PowerSetIter(boolean reverse, int limit) {
            this.delegate = CollectionsExt.toList(Combinations.this.delegate);
            this.limit = Math.min(limit, this.delegate.size());
            if (reverse) {
                this.currentRank = this.limit;
            }
            this.reverse = reverse;
        }

        @Override
        public boolean hasNext() {
            return !this.reverse && this.currentRank <= this.limit || this.reverse && this.currentRank >= 0;
        }

        @Override
        public Iterable<List<T>> next() {
            return new Iterable<List<T>>(){
                private final int rank;
                {
                    this.rank = PowerSetIter.this.reverse ? PowerSetIter.this.currentRank-- : PowerSetIter.this.currentRank++;
                }

                @Override
                public Iterator<List<T>> iterator() {
                    if (this.rank == 0) {
                        return Collections.singletonList(Collections.emptyList()).iterator();
                    }
                    return new CombinationsIterator(PowerSetIter.this.delegate, this.rank);
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

