/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import com.extollit.collect.CollectionsExt;
import com.extollit.collect.FilterIterable;
import java.util.ArrayList;
import java.util.List;

public class PermutationsIterator<T>
extends FilterIterable.Iter<List<T>> {
    private final List<T> delegate;
    private final List<T> workspace;
    private final StackEntry[] indexStack;
    private int stackPointer;

    public PermutationsIterator(Iterable<T> delegate) {
        this.delegate = delegate instanceof List ? (List<T>)delegate : CollectionsExt.toList(delegate);
        boolean empty = this.delegate.isEmpty();
        if (empty) {
            this.stackPointer = -1;
            this.indexStack = null;
            this.workspace = null;
        } else {
            this.stackPointer = 0;
            this.indexStack = new StackEntry[this.delegate.size()];
            this.workspace = new ArrayList<T>(this.delegate);
            for (int c = 0; c < this.indexStack.length; ++c) {
                StackEntry stackEntry = this.indexStack[c] = new StackEntry(this.indexStack.length - c);
                stackEntry.index = c;
                for (int j = 0; j < stackEntry.memory.length; ++j) {
                    stackEntry.memory[j] = c + j;
                }
            }
        }
    }

    @Override
    protected List<T> findNext() {
        if (this.stackPointer >= 0) {
            StackEntry current = this.indexStack[this.stackPointer];
            int mem0 = current.memory[0];
            int j = current.index - this.stackPointer;
            current.memory[0] = current.memory[j];
            current.memory[j] = mem0;
            for (int j2 = this.stackPointer + 1; j2 < this.indexStack.length; ++j2) {
                StackEntry thisStackEntry = this.indexStack[j2];
                System.arraycopy(current.memory, j2 - this.stackPointer, thisStackEntry.memory, 0, thisStackEntry.memory.length);
            }
            for (int c = this.stackPointer; c < this.indexStack.length; ++c) {
                this.workspace.set(c, this.delegate.get(current.memory[c - this.stackPointer]));
            }
            this.stackPointer = this.indexStack.length - 1;
            while (this.stackPointer >= 0 && ++this.indexStack[this.stackPointer].index >= this.indexStack.length) {
                --this.stackPointer;
                this.indexStack[this.stackPointer].index = this.indexStack[this.stackPointer].index;
            }
            return new ArrayList<T>(this.workspace);
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Permutations / combinations iterator does not support eviction due it's non-injective delegate collection functional mapping... such compleat, very grandiloquence, wow");
    }

    private static final class StackEntry {
        public int index;
        public final int[] memory;

        private StackEntry(int rank) {
            this.memory = new int[rank];
        }
    }
}

