/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.roadnetwork.content;

import com.github.retrooper.packetevents.protocol.particle.Particle;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleDustData;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerParticle;
import com.typewritermc.core.utils.point.CoordinateKt;
import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.core.utils.point.PositionKt;
import com.typewritermc.engine.paper.content.ContentComponent;
import com.typewritermc.engine.paper.extensions.packetevents.PlayerPacketsKt;
import com.typewritermc.engine.paper.utils.ExtensionsKt;
import com.typewritermc.engine.paper.utils.PointKt;
import com.typewritermc.roadnetwork.RoadEdge;
import com.typewritermc.roadnetwork.RoadNode;
import com.typewritermc.roadnetwork.RoadNodeId;
import com.typewritermc.roadnetwork.content.RoadNetworkContentModeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/typewritermc/roadnetwork/content/NetworkEdgesComponent;", "Lcom/typewritermc/engine/paper/content/ContentComponent;", "fetchNodes", "Lkotlin/Function0;", "", "Lcom/typewritermc/roadnetwork/RoadNode;", "fetchEdges", "Lcom/typewritermc/roadnetwork/RoadEdge;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "cycle", "", "showingEdges", "Lcom/typewritermc/roadnetwork/content/NetworkEdgesComponent$ShowingEdge;", "initialize", "", "player", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshEdges", "tick", "easeInOutQuad", "", "dispose", "ShowingEdge", "Companion", "RoadNetworkExtension"})
@SourceDebugExtension(value={"SMAP\nRoadNetworkContentMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoadNetworkContentMode.kt\ncom/typewritermc/roadnetwork/content/NetworkEdgesComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,382:1\n1208#2,2:383\n1236#2,4:385\n774#2:389\n865#2,2:390\n1617#2,9:392\n1869#2:401\n1870#2:403\n1626#2:404\n1869#2,2:405\n1#3:402\n*S KotlinDebug\n*F\n+ 1 RoadNetworkContentMode.kt\ncom/typewritermc/roadnetwork/content/NetworkEdgesComponent\n*L\n270#1:383,2\n270#1:385,4\n272#1:389\n272#1:390,2\n276#1:392,9\n276#1:401\n276#1:403\n276#1:404\n289#1:405,2\n276#1:402\n*E\n"})
public final class NetworkEdgesComponent
implements ContentComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<List<RoadNode>> fetchNodes;
    @NotNull
    private final Function0<List<RoadEdge>> fetchEdges;
    private int cycle;
    @NotNull
    private List<ShowingEdge> showingEdges;
    public static final int EDGE_SHOW_DURATION = 50;

    public NetworkEdgesComponent(@NotNull Function0<? extends List<RoadNode>> fetchNodes, @NotNull Function0<? extends List<RoadEdge>> fetchEdges) {
        Intrinsics.checkNotNullParameter(fetchNodes, (String)"fetchNodes");
        Intrinsics.checkNotNullParameter(fetchEdges, (String)"fetchEdges");
        this.fetchNodes = fetchNodes;
        this.fetchEdges = fetchEdges;
        this.showingEdges = CollectionsKt.emptyList();
    }

    @Nullable
    public Object initialize(@NotNull Player player, @NotNull Continuation<? super Unit> $completion) {
        this.cycle = 0;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshEdges(Player player) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = (Iterable)this.fetchNodes.invoke();
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            RoadNode roadNode = (RoadNode)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(RoadNodeId.box-impl(it.getId-f7itUo0()), element$iv$iv);
        }
        Map nodes = destination$iv$iv;
        $this$associateBy$iv = (Iterable)this.fetchEdges.invoke();
        object = this;
        boolean $i$f$filter = false;
        void capacity$iv22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RoadEdge it = (RoadEdge)element$iv$iv;
            boolean bl = false;
            Object object2 = (RoadNode)nodes.get(RoadNodeId.box-impl(it.getStart-f7itUo0()));
            boolean bl2 = (object2 != null && (object2 = ((RoadNode)object2).getPosition()) != null && (object2 = PositionKt.distanceSqrt((Point)((Point)object2), (Point)((Point)PointKt.getPosition((Player)player)))) != null ? (Double)object2 : Double.MAX_VALUE) < RoadNetworkContentModeKt.access$getShowEdgeDistance() * RoadNetworkContentModeKt.access$getShowEdgeDistance();
            if (!bl2) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ShowingEdge showingEdge;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RoadEdge edge = (RoadEdge)element$iv$iv;
            boolean bl3 = false;
            RoadNode roadNode = (RoadNode)nodes.get(RoadNodeId.box-impl(edge.getStart-f7itUo0()));
            if (roadNode == null || (roadNode = roadNode.getPosition()) == null) {
                showingEdge = null;
            } else {
                RoadNode start = roadNode;
                RoadNode roadNode2 = (RoadNode)nodes.get(RoadNodeId.box-impl(edge.getEnd-f7itUo0()));
                if (roadNode2 == null || (roadNode2 = roadNode2.getPosition()) == null) {
                    showingEdge = null;
                } else {
                    RoadNode end = roadNode2;
                    showingEdge = new ShowingEdge((Position)start, (Position)end, Companion.colorFromHash(RoadNodeId.hashCode-impl(edge.getStart-f7itUo0())));
                }
            }
            if (showingEdge == null) continue;
            ShowingEdge it$iv$iv = showingEdge;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        ((NetworkEdgesComponent)object).showingEdges = (List)destination$iv$iv2;
    }

    @Nullable
    public Object tick(@NotNull Player player, @NotNull Continuation<? super Unit> $completion) {
        if (this.cycle == 0) {
            this.refreshEdges(player);
        }
        double progress = this.easeInOutQuad((double)this.cycle / (double)50);
        Iterable $this$forEach$iv = this.showingEdges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShowingEdge edge = (ShowingEdge)element$iv;
            boolean bl = false;
            Position start = edge.getStartPosition();
            Position end = edge.getEndPosition();
            for (int i = 0; i < 2; ++i) {
                double percentage = progress - (double)i * 0.05;
                Position position = (Position)CoordinateKt.lerp((Point)((Point)start), (Point)((Point)end), (double)percentage);
                PlayerPacketsKt.sendPacketTo((PacketWrapper)((PacketWrapper)new WrapperPlayServerParticle(new Particle(ParticleTypes.DUST, (ParticleData)new ParticleDustData(1.0f, ExtensionsKt.toPacketColor((Color)edge.getColor()))), true, PointKt.toPacketVector3d((Point)((Point)position)), Vector3f.zero(), 0.0f, 1)), (Player)player);
            }
        }
        int n = this.cycle;
        this.cycle = n + 1;
        if (this.cycle > 50) {
            this.cycle = 0;
        }
        return Unit.INSTANCE;
    }

    private final double easeInOutQuad(double $this$easeInOutQuad) {
        return $this$easeInOutQuad < 0.5 ? (double)2 * $this$easeInOutQuad * $this$easeInOutQuad : (double)-1 + ((double)4 - (double)2 * $this$easeInOutQuad) * $this$easeInOutQuad;
    }

    @Nullable
    public Object dispose(@NotNull Player player, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/typewritermc/roadnetwork/content/NetworkEdgesComponent$Companion;", "", "<init>", "()V", "EDGE_SHOW_DURATION", "", "colorFromHash", "Lorg/bukkit/Color;", "hash", "RoadNetworkExtension"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color colorFromHash(int hash) {
            double r = (double)(hash >> 16 & 0xFF) / 255.0;
            double g = (double)(hash >> 8 & 0xFF) / 255.0;
            double b = (double)(hash & 0xFF) / 255.0;
            Color color = Color.fromRGB((int)((int)(r * (double)255)), (int)((int)(g * (double)255)), (int)((int)(b * (double)255)));
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"fromRGB(...)");
            return color;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/typewritermc/roadnetwork/content/NetworkEdgesComponent$ShowingEdge;", "", "startPosition", "Lcom/typewritermc/core/utils/point/Position;", "endPosition", "color", "Lorg/bukkit/Color;", "<init>", "(Lcom/typewritermc/core/utils/point/Position;Lcom/typewritermc/core/utils/point/Position;Lorg/bukkit/Color;)V", "getStartPosition", "()Lcom/typewritermc/core/utils/point/Position;", "getEndPosition", "getColor", "()Lorg/bukkit/Color;", "RoadNetworkExtension"})
    public static final class ShowingEdge {
        @NotNull
        private final Position startPosition;
        @NotNull
        private final Position endPosition;
        @NotNull
        private final Color color;

        public ShowingEdge(@NotNull Position startPosition, @NotNull Position endPosition, @NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
            Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.color = color;
        }

        public /* synthetic */ ShowingEdge(Position position, Position position2, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                Color color2 = Color.RED;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"RED");
                color = color2;
            }
            this(position, position2, color);
        }

        @NotNull
        public final Position getStartPosition() {
            return this.startPosition;
        }

        @NotNull
        public final Position getEndPosition() {
            return this.endPosition;
        }

        @NotNull
        public final Color getColor() {
            return this.color;
        }
    }
}

