/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.roadnetwork.pathfinding;

import com.extollit.gaming.ai.path.model.IBlockDescription;
import com.extollit.gaming.ai.path.model.IBlockObject;
import com.extollit.linalg.immutable.AxisAlignedBBox;
import com.typewritermc.core.utils.point.Point;
import com.typewritermc.core.utils.point.Position;
import com.typewritermc.engine.paper.utils.PointKt;
import com.typewritermc.roadnetwork.pathfinding.PFBlockKt;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\b\u0010 \u001a\u00020\u001aH\u0016J\b\u0010!\u001a\u00020\u001aH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/typewritermc/roadnetwork/pathfinding/PFBlock;", "Lcom/extollit/gaming/ai/path/model/IBlockDescription;", "Lcom/extollit/gaming/ai/path/model/IBlockObject;", "position", "Lcom/typewritermc/core/utils/point/Position;", "type", "Lorg/bukkit/Material;", "data", "Lorg/bukkit/block/data/BlockData;", "<init>", "(Lcom/typewritermc/core/utils/point/Position;Lorg/bukkit/Material;Lorg/bukkit/block/data/BlockData;)V", "getPosition", "()Lcom/typewritermc/core/utils/point/Position;", "getType", "()Lorg/bukkit/Material;", "getData", "()Lorg/bukkit/block/data/BlockData;", "collisionShape", "Lorg/bukkit/util/VoxelShape;", "getCollisionShape", "()Lorg/bukkit/util/VoxelShape;", "collisionShape$delegate", "Lkotlin/Lazy;", "bounds", "Lcom/extollit/linalg/immutable/AxisAlignedBBox;", "isFenceLike", "", "isClimbable", "isDoor", "isIntractable", "isImpeding", "isFullyBounded", "isLiquid", "isIncinerating", "RoadNetworkExtension"})
public final class PFBlock
implements IBlockDescription,
IBlockObject {
    @NotNull
    private final Position position;
    @NotNull
    private final Material type;
    @NotNull
    private final BlockData data;
    @NotNull
    private final Lazy collisionShape$delegate;

    public PFBlock(@NotNull Position position, @NotNull Material type, @NotNull BlockData data) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.position = position;
        this.type = type;
        this.data = data;
        this.collisionShape$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> PFBlock.collisionShape_delegate$lambda$0(this));
    }

    @NotNull
    public final Position getPosition() {
        return this.position;
    }

    @NotNull
    public final Material getType() {
        return this.type;
    }

    @NotNull
    public final BlockData getData() {
        return this.data;
    }

    private final VoxelShape getCollisionShape() {
        Lazy lazy = this.collisionShape$delegate;
        return (VoxelShape)lazy.getValue();
    }

    @Override
    @NotNull
    public AxisAlignedBBox bounds() {
        return PFBlockKt.access$toAABB(this.getCollisionShape());
    }

    @Override
    public boolean isFenceLike() {
        return PFBlockKt.access$getFenceLikeMaterials$p().contains(this.type.getKey());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isClimbable() {
        if (this.type == Material.LADDER) return true;
        String string = this.type.getKey().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"vine", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Override
    public boolean isDoor() {
        String string = this.type.getKey().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        return StringsKt.endsWith$default((String)string, (String)"door", (boolean)false, (int)2, null);
    }

    @Override
    public boolean isIntractable() {
        return false;
    }

    @Override
    public boolean isImpeding() {
        return this.type.isSolid();
    }

    @Override
    public boolean isFullyBounded() {
        if (this.getCollisionShape().getBoundingBoxes().size() != 1) {
            return false;
        }
        Collection collection = this.getCollisionShape().getBoundingBoxes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getBoundingBoxes(...)");
        BoundingBox boundingBox = (BoundingBox)CollectionsKt.first((Iterable)collection);
        return boundingBox.getMinX() == 0.0 && boundingBox.getMinY() == 0.0 && boundingBox.getMinZ() == 0.0 && boundingBox.getWidthX() == 1.0 && boundingBox.getHeight() == 1.0 && boundingBox.getWidthZ() == 1.0;
    }

    @Override
    public boolean isLiquid() {
        return this.type == Material.WATER || this.type == Material.LAVA;
    }

    @Override
    public boolean isIncinerating() {
        return this.type == Material.LAVA || this.type == Material.FIRE || this.type == Material.SOUL_FIRE || this.type == Material.MAGMA_BLOCK;
    }

    private static final VoxelShape collisionShape_delegate$lambda$0(PFBlock this$0) {
        VoxelShape voxelShape = this$0.data.getCollisionShape(PointKt.toBukkitLocation((Point)((Point)this$0.position)));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"getCollisionShape(...)");
        return voxelShape;
    }
}

