/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.vault;

import com.typewritermc.core.extension.Initializable;
import com.typewritermc.core.extension.annotations.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u0004\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/typewritermc/vault/VaultInitializer;", "Lcom/typewritermc/core/extension/Initializable;", "<init>", "()V", "value", "Lnet/milkbowl/vault/economy/Economy;", "economy", "getEconomy", "()Lnet/milkbowl/vault/economy/Economy;", "Lnet/milkbowl/vault/permission/Permission;", "permissions", "getPermissions", "()Lnet/milkbowl/vault/permission/Permission;", "Lnet/milkbowl/vault/chat/Chat;", "chat", "getChat", "()Lnet/milkbowl/vault/chat/Chat;", "initialize", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shutdown", "loadVault", "setupEconomy", "", "setupPermissions", "setupChat", "VaultExtension"})
public final class VaultInitializer
implements Initializable {
    @Nullable
    private Economy economy;
    @Nullable
    private Permission permissions;
    @Nullable
    private Chat chat;

    @Nullable
    public final Economy getEconomy() {
        return this.economy;
    }

    @Nullable
    public final Permission getPermissions() {
        return this.permissions;
    }

    @Nullable
    public final Chat getChat() {
        return this.chat;
    }

    @Nullable
    public Object initialize(@NotNull Continuation<? super Unit> $completion) {
        this.loadVault();
        return Unit.INSTANCE;
    }

    @Nullable
    public Object shutdown(@NotNull Continuation<? super Unit> $completion) {
        this.economy = null;
        this.permissions = null;
        this.chat = null;
        return Unit.INSTANCE;
    }

    private final void loadVault() {
        this.setupEconomy();
        this.setupPermissions();
        this.setupChat();
    }

    private final boolean setupEconomy() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider == null) {
            return false;
        }
        RegisteredServiceProvider rsp = registeredServiceProvider;
        this.economy = (Economy)rsp.getProvider();
        return true;
    }

    private final boolean setupPermissions() {
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
        Object object = registeredServiceProvider instanceof RegisteredServiceProvider ? registeredServiceProvider : null;
        if (object == null) {
            return false;
        }
        RegisteredServiceProvider rsp = object;
        this.permissions = (Permission)rsp.getProvider();
        return true;
    }

    private final boolean setupChat() {
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServer().getServicesManager().getRegistration(Chat.class);
        Object object = registeredServiceProvider instanceof RegisteredServiceProvider ? registeredServiceProvider : null;
        if (object == null) {
            return false;
        }
        RegisteredServiceProvider rsp = object;
        this.chat = (Chat)rsp.getProvider();
        return true;
    }
}

