/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.worldguard;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import com.typewritermc.core.extension.Initializable;
import com.typewritermc.core.extension.annotations.Singleton;
import com.typewritermc.engine.paper.TypewriterPaperPluginKt;
import com.typewritermc.engine.paper.utils.ServerExtensionsKt;
import com.typewritermc.worldguard.WorldGuardHandler;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/typewritermc/worldguard/WorldGuardInitializer;", "Lcom/typewritermc/core/extension/Initializable;", "<init>", "()V", "factory", "Lcom/typewritermc/worldguard/WorldGuardHandler$Factory;", "initialize", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shutdown", "WorldGuardExtension"})
@SourceDebugExtension(value={"SMAP\nWorldGuardInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldGuardInitializer.kt\ncom/typewritermc/worldguard/WorldGuardInitializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1869#2,2:63\n1869#2,2:65\n*S KotlinDebug\n*F\n+ 1 WorldGuardInitializer.kt\ncom/typewritermc/worldguard/WorldGuardInitializer\n*L\n32#1:63,2\n50#1:65,2\n*E\n"})
public final class WorldGuardInitializer
implements Initializable {
    @NotNull
    private final WorldGuardHandler.Factory factory = WorldGuardHandler.Factory.INSTANCE;

    @Nullable
    public Object initialize(@NotNull Continuation<? super Unit> $completion) {
        WorldGuardPlugin worldGuardPlugin;
        WorldGuard worldGuard = WorldGuard.getInstance();
        boolean registered = worldGuard.getPlatform().getSessionManager().registerHandler((Handler.Factory)this.factory, null);
        if (!registered) {
            TypewriterPaperPluginKt.getLogger().warning("Failed to register WorldGuardHandler. This is a bug, please report it on the Typewriter Discord.");
            return Unit.INSTANCE;
        }
        Plugin plugin = ServerExtensionsKt.getServer().getPluginManager().getPlugin("WorldGuard");
        WorldGuardPlugin worldGuardPlugin2 = worldGuardPlugin = plugin instanceof WorldGuardPlugin ? (WorldGuardPlugin)plugin : null;
        if (worldGuardPlugin == null) {
            TypewriterPaperPluginKt.getLogger().warning("WorldGuard plugin not found, so WorldGuard will not be enabled.");
            return Unit.INSTANCE;
        }
        Collection collection = ServerExtensionsKt.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Session session;
            Player player = (Player)element$iv;
            boolean bl = false;
            LocalPlayer bukkitPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            if (worldGuard.getPlatform().getSessionManager().getIfPresent(bukkitPlayer) == null) continue;
            boolean bl2 = false;
            WorldGuardHandler currentHandler = (WorldGuardHandler)session.getHandler(WorldGuardHandler.class);
            if (currentHandler != null) continue;
            session.register((Handler)this.factory.create(session));
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object shutdown(@NotNull Continuation<? super Unit> $completion) {
        WorldGuard.getInstance().getPlatform().getSessionManager().unregisterHandler((Handler.Factory)this.factory);
        Collection collection = ServerExtensionsKt.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Session session;
            Field field;
            Player player = (Player)element$iv;
            boolean bl = false;
            LocalPlayer bukkitPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            if (WorldGuard.getInstance().getPlatform().getSessionManager().getIfPresent(bukkitPlayer) == null) continue;
            boolean bl2 = false;
            Field $this$shutdown_u24lambda_u244_u24lambda_u243_u24lambda_u242 = field = session.getClass().getDeclaredField("handlers");
            boolean bl3 = false;
            $this$shutdown_u24lambda_u244_u24lambda_u243_u24lambda_u242.setAccessible(true);
            Object object = $this$shutdown_u24lambda_u244_u24lambda_u243_u24lambda_u242.get(session);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<java.lang.Class<*>, kotlin.Any>");
            Map handlers = TypeIntrinsics.asMutableMap((Object)object);
            handlers.remove(WorldGuardHandler.class);
        }
        return Unit.INSTANCE;
    }
}

