/*
 * Decompiled with CFR 0.152.
 */
package com.typewritermc.worldguard.entries.audience;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.typewritermc.core.entries.Ref;
import com.typewritermc.engine.paper.entry.entries.AudienceFilter;
import com.typewritermc.engine.paper.entry.entries.AudienceFilterEntry;
import com.typewritermc.worldguard.events.RegionsEnterEvent;
import com.typewritermc.worldguard.events.RegionsExitEvent;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/typewritermc/worldguard/entries/audience/RegionAudienceFilter;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilter;", "ref", "Lcom/typewritermc/core/entries/Ref;", "Lcom/typewritermc/engine/paper/entry/entries/AudienceFilterEntry;", "region", "", "<init>", "(Lcom/typewritermc/core/entries/Ref;Ljava/lang/String;)V", "onRegionEnter", "", "event", "Lcom/typewritermc/worldguard/events/RegionsEnterEvent;", "onRegionLeave", "Lcom/typewritermc/worldguard/events/RegionsExitEvent;", "filter", "", "player", "Lorg/bukkit/entity/Player;", "WorldGuardExtension"})
@SourceDebugExtension(value={"SMAP\nRegionAudienceEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegionAudienceEntry.kt\ncom/typewritermc/worldguard/entries/audience/RegionAudienceFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n2746#2,3:71\n2746#2,3:74\n1761#2,3:77\n*S KotlinDebug\n*F\n+ 1 RegionAudienceEntry.kt\ncom/typewritermc/worldguard/entries/audience/RegionAudienceFilter\n*L\n51#1:71,3\n58#1:74,3\n68#1:77,3\n*E\n"})
public final class RegionAudienceFilter
extends AudienceFilter {
    @NotNull
    private final String region;

    public RegionAudienceFilter(@NotNull Ref<? extends AudienceFilterEntry> ref, @NotNull String region) {
        Intrinsics.checkNotNullParameter(ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        super(ref);
        this.region = region;
    }

    @EventHandler
    public final void onRegionEnter(@NotNull RegionsEnterEvent event) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            if (!this.canConsider(player)) {
                return;
            }
            Iterable $this$none$iv = event.getRegions();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ProtectedRegion it = (ProtectedRegion)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.region)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.updateFilter(player, true);
    }

    @EventHandler
    public final void onRegionLeave(@NotNull RegionsExitEvent event) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            if (!this.canConsider(player)) {
                return;
            }
            Iterable $this$none$iv = event.getRegions();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ProtectedRegion it = (ProtectedRegion)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.region)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.updateFilter(player, false);
    }

    public boolean filter(@NotNull Player player) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
            RegionManager regionManager = regionContainer.get(BukkitAdapter.adapt((World)player.getWorld()));
            RegionManager regionManager2 = regionManager;
            if (regionManager2 == null || (regionManager2 = regionManager2.getApplicableRegions(BukkitAdapter.asBlockVector((Location)player.getLocation()))) == null) {
                return false;
            }
            RegionManager regions = regionManager2;
            Set set = regions.getRegions();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRegions(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ProtectedRegion it = (ProtectedRegion)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.region)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

