/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.arrowpointers.util;

import eu.pintergabor.arrowpointers.blocks.ArrowMarkBlock;
import eu.pintergabor.arrowpointers.util.BlockRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public final class ClickAction {
    private ClickAction() {
    }

    @NotNull
    private static InteractionResult placeBlock(UseOnContext context, Block block, BlockRegion orientation, int consume) {
        BlockState blockState;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        Direction clickedFace = context.getClickedFace();
        BlockPos targetPos = pos.relative(clickedFace);
        if (level.setBlockAndUpdate(targetPos, blockState = (BlockState)((BlockState)block.defaultBlockState().setValue(ArrowMarkBlock.FACING, (Comparable)clickedFace)).setValue(ArrowMarkBlock.ORIENTATION, (Comparable)((Object)orientation)))) {
            if (player != null && !player.isCreative()) {
                context.getItemInHand().shrink(consume);
            }
            level.playSound(null, targetPos, SoundEvents.LADDER_BREAK, SoundSource.BLOCKS, 0.5f, RandomSource.create().nextFloat() * 0.2f + 0.8f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    private static InteractionResult placeBlock(UseOnContext context, Block block) {
        BlockRegion orientation = BlockRegion.getClickedRegion(context.getClickLocation(), context.getClickedFace());
        int consume = 1;
        if (orientation == BlockRegion.MIDDLECENTER) {
            if (context.getItemInHand().getCount() < 2) {
                return InteractionResult.PASS;
            }
            consume = 2;
        }
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        return ClickAction.placeBlock(context, block, orientation, consume);
    }

    private static boolean canPlace(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState clickedBlockState = level.getBlockState(pos);
        Player player = context.getPlayer();
        Direction clickedFace = context.getClickedFace();
        if (player == null) {
            return false;
        }
        return Block.isFaceFull((VoxelShape)clickedBlockState.getCollisionShape((BlockGetter)level, pos, CollisionContext.of((Entity)player)), (Direction)clickedFace);
    }

    public static InteractionResult useOn(UseOnContext context, Block block) {
        Direction clickedFace;
        BlockPos pos;
        BlockPos targetPos;
        Level level = context.getLevel();
        if (!level.isEmptyBlock(targetPos = (pos = context.getClickedPos()).relative(clickedFace = context.getClickedFace()))) {
            return InteractionResult.FAIL;
        }
        if (!ClickAction.canPlace(context)) {
            return InteractionResult.PASS;
        }
        return ClickAction.placeBlock(context, block);
    }
}

