/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.arrowpointers.blocks;

import eu.pintergabor.arrowpointers.util.BlockRegion;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public final class ArrowMarkBlock
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public static final EnumProperty<BlockRegion> ORIENTATION = EnumProperty.create((String)"orientation", BlockRegion.class, List.of(BlockRegion.VALUES));
    private static final VoxelShape DOWN_AABB = Block.box((double)0.0, (double)15.999, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape UP_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.001, (double)16.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.001);
    private static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.001, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.box((double)15.999, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.999, (double)16.0, (double)16.0, (double)16.0);

    public ArrowMarkBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH)).setValue(ORIENTATION, (Comparable)((Object)BlockRegion.MIDDLECENTER)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ORIENTATION});
        super.createBlockStateDefinition(builder);
    }

    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, @NotNull LootParams.Builder builder) {
        List dropStacks = super.getDrops(state, builder);
        if (state.getValue(ORIENTATION) == BlockRegion.MIDDLECENTER) {
            ((ItemStack)dropStacks.getFirst()).setCount(2);
        }
        return dropStacks;
    }

    protected void spawnDestroyParticles(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (!level.isClientSide()) {
            level.playSound(null, pos, SoundEvents.MOSS_CARPET_BREAK, SoundSource.BLOCKS, 0.5f, RandomSource.create().nextFloat() * 0.2f + 0.8f);
        }
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> UP_AABB;
            case Direction.DOWN -> DOWN_AABB;
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.EAST -> EAST_AABB;
            case Direction.WEST -> WEST_AABB;
        };
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.empty();
    }

    public boolean canBeReplaced(@NotNull BlockState state, @NotNull BlockPlaceContext context) {
        return true;
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Direction facing = (Direction)state.getValue(FACING);
        return Block.isFaceFull((VoxelShape)level.getBlockState(pos.relative(facing.getOpposite())).getCollisionShape((BlockGetter)level, pos.relative(facing)), (Direction)facing);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull LevelReader level, @NotNull ScheduledTickAccess tickView, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        BlockPos supportPos = pos.relative(((Direction)state.getValue(FACING)).getOpposite());
        boolean support = neighborPos.equals((Object)supportPos);
        if (support && !this.canSurvive(state, level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }
}

