/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.arrowpointers.datagen;

import eu.pintergabor.arrowpointers.Global;
import eu.pintergabor.arrowpointers.blocks.ArrowMarkBlock;
import eu.pintergabor.arrowpointers.util.BlockRegion;
import java.util.Optional;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public final class ModModelGenerator {
    private final BlockModelGenerators generator;
    public static final String TEMPLATE = "block/template_arrow_mark";
    public static final String TEMPLATE_ROTATED = "block/template_arrow_mark_rotated";

    public ModModelGenerator(BlockModelGenerators generator) {
        this.generator = generator;
    }

    public static void registerFlatNormal(PropertyDispatch.C2<MultiVariant, Direction, BlockRegion> map, BlockRegion orientation, ResourceLocation modelId) {
        map.select((Comparable)Direction.DOWN, (Comparable)((Object)orientation), (Object)BlockModelGenerators.plainVariant((ResourceLocation)modelId).with(BlockModelGenerators.X_ROT_180));
        map.select((Comparable)Direction.UP, (Comparable)((Object)orientation), (Object)BlockModelGenerators.plainVariant((ResourceLocation)modelId));
        map.select((Comparable)Direction.NORTH, (Comparable)((Object)orientation), (Object)BlockModelGenerators.plainVariant((ResourceLocation)modelId).with(BlockModelGenerators.X_ROT_270.then(BlockModelGenerators.Y_ROT_180)));
        map.select((Comparable)Direction.SOUTH, (Comparable)((Object)orientation), (Object)BlockModelGenerators.plainVariant((ResourceLocation)modelId).with(BlockModelGenerators.X_ROT_270));
        map.select((Comparable)Direction.WEST, (Comparable)((Object)orientation), (Object)BlockModelGenerators.plainVariant((ResourceLocation)modelId).with(BlockModelGenerators.X_ROT_270.then(BlockModelGenerators.Y_ROT_90)));
        map.select((Comparable)Direction.EAST, (Comparable)((Object)orientation), (Object)BlockModelGenerators.plainVariant((ResourceLocation)modelId).with(BlockModelGenerators.X_ROT_270.then(BlockModelGenerators.Y_ROT_270)));
    }

    public static void registerFlatFlipped(PropertyDispatch.C2<MultiVariant, Direction, BlockRegion> map, BlockRegion orientation, ResourceLocation modelId) {
        map.select((Comparable)Direction.DOWN, (Comparable)((Object)orientation), (Object)BlockModelGenerators.plainVariant((ResourceLocation)modelId).with(BlockModelGenerators.X_ROT_180.then(BlockModelGenerators.Y_ROT_180)));
        map.select((Comparable)Direction.UP, (Comparable)((Object)orientation), (Object)BlockModelGenerators.plainVariant((ResourceLocation)modelId).with(BlockModelGenerators.Y_ROT_180));
        map.select((Comparable)Direction.NORTH, (Comparable)((Object)orientation), (Object)BlockModelGenerators.plainVariant((ResourceLocation)modelId).with(BlockModelGenerators.X_ROT_90));
        map.select((Comparable)Direction.SOUTH, (Comparable)((Object)orientation), (Object)BlockModelGenerators.plainVariant((ResourceLocation)modelId).with(BlockModelGenerators.X_ROT_90.then(BlockModelGenerators.Y_ROT_180)));
        map.select((Comparable)Direction.WEST, (Comparable)((Object)orientation), (Object)BlockModelGenerators.plainVariant((ResourceLocation)modelId).with(BlockModelGenerators.X_ROT_90.then(BlockModelGenerators.Y_ROT_270)));
        map.select((Comparable)Direction.EAST, (Comparable)((Object)orientation), (Object)BlockModelGenerators.plainVariant((ResourceLocation)modelId).with(BlockModelGenerators.X_ROT_90.then(BlockModelGenerators.Y_ROT_90)));
    }

    public ResourceLocation createFlatModel(Block block, String template, String modelSuffix, String textureSuffix) {
        ModelTemplate model = new ModelTemplate(Optional.of(Global.modId(template)), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
        return this.generator.createSuffixedVariant(block, modelSuffix, model, identifier -> new TextureMapping().put(TextureSlot.TEXTURE, ModelLocationUtils.getModelLocation((Block)block, (String)textureSuffix)));
    }

    public PropertyDispatch<MultiVariant> createFlat9Direction(Block block) {
        ResourceLocation center = this.createFlatModel(block, TEMPLATE, "_center", "_center");
        ResourceLocation topleft = this.createFlatModel(block, TEMPLATE_ROTATED, "_top_left", "_diagonal");
        ResourceLocation top = this.createFlatModel(block, TEMPLATE, "_top", "");
        ResourceLocation topright = this.createFlatModel(block, TEMPLATE, "_top_right", "_diagonal");
        ResourceLocation left = this.createFlatModel(block, TEMPLATE_ROTATED, "_left", "");
        PropertyDispatch.C2 map = PropertyDispatch.initial((Property)BlockStateProperties.FACING, ArrowMarkBlock.ORIENTATION);
        ModModelGenerator.registerFlatNormal((PropertyDispatch.C2<MultiVariant, Direction, BlockRegion>)map, BlockRegion.TOPLEFT, topleft);
        ModModelGenerator.registerFlatNormal((PropertyDispatch.C2<MultiVariant, Direction, BlockRegion>)map, BlockRegion.TOPCENTER, top);
        ModModelGenerator.registerFlatNormal((PropertyDispatch.C2<MultiVariant, Direction, BlockRegion>)map, BlockRegion.TOPRIGHT, topright);
        ModModelGenerator.registerFlatNormal((PropertyDispatch.C2<MultiVariant, Direction, BlockRegion>)map, BlockRegion.MIDDLELEFT, left);
        ModModelGenerator.registerFlatNormal((PropertyDispatch.C2<MultiVariant, Direction, BlockRegion>)map, BlockRegion.MIDDLECENTER, center);
        ModModelGenerator.registerFlatFlipped((PropertyDispatch.C2<MultiVariant, Direction, BlockRegion>)map, BlockRegion.MIDDLERIGHT, left);
        ModModelGenerator.registerFlatFlipped((PropertyDispatch.C2<MultiVariant, Direction, BlockRegion>)map, BlockRegion.BOTTOMLEFT, topright);
        ModModelGenerator.registerFlatFlipped((PropertyDispatch.C2<MultiVariant, Direction, BlockRegion>)map, BlockRegion.BOTTOMCENTER, top);
        ModModelGenerator.registerFlatFlipped((PropertyDispatch.C2<MultiVariant, Direction, BlockRegion>)map, BlockRegion.BOTTOMRIGHT, topleft);
        return map;
    }

    public void registerFlat9Direction(Block block) {
        this.generator.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(this.createFlat9Direction(block)));
    }
}

