/*
 * Decompiled with CFR 0.152.
 */
package eu.pintergabor.arrowpointers.util;

import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public enum BlockRegion implements StringRepresentable
{
    TOPLEFT("top_left"),
    TOPCENTER("top_center"),
    TOPRIGHT("top_right"),
    MIDDLELEFT("middle_left"),
    MIDDLECENTER("middle_center"),
    MIDDLERIGHT("middle_right"),
    BOTTOMLEFT("bottom_left"),
    BOTTOMCENTER("bottom_center"),
    BOTTOMRIGHT("bottom_right");

    public static final BlockRegion[] VALUES;
    private final String name;

    private BlockRegion(String name) {
        this.name = name;
    }

    private static double frac(double v) {
        return v - Math.floor(v);
    }

    private static BlockRegion blockreg(int rx, int ry) {
        return VALUES[3 * rx + ry];
    }

    private static BlockRegion blockreg3(double rx, double ry) {
        return BlockRegion.blockreg(Math.min(2, (int)(3.0 * rx)), Math.min(2, (int)(3.0 * ry)));
    }

    public static BlockRegion getClickedRegion(@NotNull Vec3 clickLocation, Direction face) {
        double dx = BlockRegion.frac(clickLocation.x);
        double dy = BlockRegion.frac(clickLocation.y);
        double dz = BlockRegion.frac(clickLocation.z);
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> BlockRegion.blockreg3(dz, dx);
            case Direction.DOWN -> BlockRegion.blockreg3(1.0 - dz, dx);
            case Direction.NORTH -> BlockRegion.blockreg3(1.0 - dy, 1.0 - dx);
            case Direction.SOUTH -> BlockRegion.blockreg3(1.0 - dy, dx);
            case Direction.EAST -> BlockRegion.blockreg3(1.0 - dy, 1.0 - dz);
            case Direction.WEST -> BlockRegion.blockreg3(1.0 - dy, dz);
        };
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    static {
        VALUES = BlockRegion.values();
    }
}

