/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.saplanting.mixin;

import cool.muyucloud.saplanting.Saplanting;
import cool.muyucloud.saplanting.access.BushBlockAccess;
import cool.muyucloud.saplanting.access.SaplingBlockAccess;
import cool.muyucloud.saplanting.access.TreeGrowerAccess;
import cool.muyucloud.saplanting.util.Config;
import cool.muyucloud.saplanting.util.PlantContext;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity {
    @Unique
    private static final Config CONFIG = Saplanting.getConfig();
    @Unique
    private static final Logger LOGGER = Saplanting.getLogger();
    @Unique
    private static final ConcurrentLinkedQueue<ItemEntityMixin> CHECK_TASKS = new ConcurrentLinkedQueue();
    @Unique
    private static final HashSet<Item> CONTAIN_ERROR = new HashSet();
    @Unique
    private int plantAge = 0;

    @Shadow
    public abstract Component getName();

    @Shadow
    public abstract ItemStack getItem();

    public ItemEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        if (this.level().isClientSide() || !CONFIG.getAsBoolean("plantEnable")) {
            return;
        }
        Item item = this.getItem().getItem();
        if (CONTAIN_ERROR.contains(item) || !Saplanting.isPlantItem(item)) {
            return;
        }
        if (!CONFIG.getAsBoolean("multiThread")) {
            Saplanting.THREAD_ALIVE = false;
            this.run();
            return;
        }
        if (!Saplanting.THREAD_ALIVE) {
            Saplanting.THREAD_ALIVE = true;
            LOGGER.info("Launching Saplanting core thread.");
            Thread thread = new Thread(ItemEntityMixin::multiThreadRun);
            thread.setName("SaplantingCoreThread");
            thread.start();
        }
        this.addToQueue();
    }

    @Unique
    private boolean tickCheck() {
        Item item = this.getItem().getItem();
        if (!(this.onGround() && CONFIG.getAsBoolean("plantEnable") && Saplanting.isPlantAllowed(item))) {
            return false;
        }
        BlockPos pos = this.blockPosition();
        if (this.getY() % 1.0 != 0.0) {
            pos = pos.above();
        }
        if (!this.level().getBlockState(pos).canBeReplaced()) {
            return false;
        }
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            BlockState state = block.defaultBlockState();
            if (!state.getFluidState().isEmpty()) {
                return false;
            }
            return this.isPosValid(pos);
        }
        return true;
    }

    @Unique
    private boolean roundCheck() {
        int playerAround;
        Item item = this.getItem().getItem();
        if (!(item instanceof BlockItem)) {
            return true;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        BlockPos pos = this.blockPosition();
        if (this.getY() % 1.0 != 0.0) {
            pos = pos.above();
        }
        if ((playerAround = CONFIG.getAsInt("playerAround")) > 0 && this.level().hasNearbyAlivePlayer(this.getX(), this.getY(), this.getZ(), (double)playerAround)) {
            return false;
        }
        int avoidDense = CONFIG.getAsInt("avoidDense");
        if (block instanceof SaplingBlock && avoidDense > 0) {
            for (BlockPos tmpPos : BlockPos.betweenClosed((BlockPos)pos.offset(avoidDense, avoidDense, avoidDense), (BlockPos)pos.offset(-avoidDense, -avoidDense, -avoidDense))) {
                Block tmpBlock = this.level().getBlockState(tmpPos).getBlock();
                BlockState state = tmpBlock.defaultBlockState();
                if (!(tmpBlock instanceof LeavesBlock) && !(tmpBlock instanceof SaplingBlock) && !state.is(BlockTags.LOGS)) continue;
                return false;
            }
        }
        return true;
    }

    @Unique
    private void plant() {
        Item item;
        Level world = this.level();
        ItemStack stack = this.getItem();
        BlockPos pos = this.blockPosition();
        if (this.getY() % 1.0 != 0.0) {
            pos = pos.above();
        }
        if ((item = stack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            BlockState state = block.defaultBlockState();
            if (block instanceof SaplingBlock) {
                SaplingBlock saplingBlock = (SaplingBlock)block;
                TreeGrowerAccess generator = (TreeGrowerAccess)((SaplingBlockAccess)block).saplanting$getTreeGrower();
                if (CONFIG.getAsBoolean("plantLarge") && stack.getCount() >= 4 && generator.saplanting_fabric$hasLargeTree()) {
                    for (BlockPos tmpPos : BlockPos.betweenClosed((BlockPos)pos, (BlockPos)pos.offset(-1, 0, -1))) {
                        if (!((BushBlockAccess)saplingBlock).saplanting$invokeCanSurvive(state, (LevelReader)world, tmpPos) || !world.getBlockState(tmpPos).canBeReplaced() || !((BushBlockAccess)saplingBlock).saplanting$invokeCanSurvive(state, (LevelReader)world, tmpPos.offset(1, 0, 0)) || !world.getBlockState(tmpPos.offset(1, 0, 0)).canBeReplaced() || !((BushBlockAccess)saplingBlock).saplanting$invokeCanSurvive(state, (LevelReader)world, tmpPos.offset(1, 0, 1)) || !world.getBlockState(tmpPos.offset(1, 0, 1)).canBeReplaced() || !((BushBlockAccess)saplingBlock).saplanting$invokeCanSurvive(state, (LevelReader)world, tmpPos.offset(0, 0, 1)) || !world.getBlockState(tmpPos.offset(0, 0, 1)).canBeReplaced()) continue;
                        PlantContext context = new PlantContext();
                        context.setStack(stack);
                        context.setPos(tmpPos);
                        context.setWorld((ServerLevel)world);
                        context.setLarge(true);
                        PlantContext.PLANT_TASKS.offer(context);
                        return;
                    }
                }
                if (!CONFIG.getAsBoolean("ignoreShape") && !generator.saplanting_fabric$hasSmallTree()) {
                    return;
                }
            }
        }
        PlantContext context = new PlantContext();
        context.setStack(stack);
        context.setPos(pos);
        context.setWorld((ServerLevel)world);
        context.setLarge(false);
        PlantContext.PLANT_TASKS.offer(context);
    }

    @Unique
    @Nullable
    private BlockPos findLargeSpace(@NotNull BlockPos center) {
        if (this.isPosValid(center).booleanValue()) {
            BlockPos pos = center.offset(-1, 0, 0);
            if (this.isPosValid(pos).booleanValue()) {
                pos = center.offset(0, 0, 1);
                if (this.isPosValid(pos).booleanValue()) {
                    pos = center.offset(-1, 0, 1);
                    if (this.isPosValid(pos).booleanValue()) {
                        return center.offset(-1, 0, 1);
                    }
                    pos = center.offset(0, 0, -1);
                    if (this.isPosValid(pos).booleanValue()) {
                        pos = center.offset(-1, 0, -1);
                        if (this.isPosValid(pos).booleanValue()) {
                            return center.offset(-1, 0, 0);
                        }
                        pos = center.offset(1, 0, 0);
                        if (this.isPosValid(pos).booleanValue()) {
                            pos = center.offset(1, 0, 1);
                            if (this.isPosValid(pos).booleanValue()) {
                                return center.offset(0, 0, 1);
                            }
                            pos = center.offset(1, 0, -1);
                            if (this.isPosValid(pos).booleanValue()) {
                                return center;
                            }
                            return null;
                        }
                        return null;
                    }
                    if (this.isPosValid(center.offset(1, 0, 0)).booleanValue() && this.isPosValid(center.offset(1, 0, 1)).booleanValue()) {
                        return center.offset(0, 0, 1);
                    }
                    return null;
                }
                pos = center.offset(0, 0, -1);
                if (this.isPosValid(pos).booleanValue()) {
                    pos = center.offset(-1, 0, -1);
                    if (this.isPosValid(pos).booleanValue()) {
                        return center.offset(-1, 0, 0);
                    }
                    if (this.isPosValid(center.offset(1, 0, 0)).booleanValue() && this.isPosValid(center.offset(1, 0, -1)).booleanValue()) {
                        return center;
                    }
                    return null;
                }
                return null;
            }
            pos = center.offset(1, 0, 0);
            if (this.isPosValid(pos).booleanValue()) {
                pos = center.offset(0, 0, 1);
                if (this.isPosValid(pos).booleanValue()) {
                    pos = center.offset(1, 0, 1);
                    if (this.isPosValid(pos).booleanValue()) {
                        return center;
                    }
                    if (this.isPosValid(center.offset(0, 0, -1)).booleanValue() && this.isPosValid(center.offset(1, 0, -1)).booleanValue()) {
                        return center;
                    }
                    return null;
                }
                if (this.isPosValid(center.offset(0, 0, -1)).booleanValue() && this.isPosValid(center.offset(1, 0, -1)).booleanValue()) {
                    return center;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Unique
    private Boolean isPosValid(@NotNull BlockPos pos) {
        BlockItem blockItem;
        Block block;
        Item item = this.getItem().getItem();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof BushBlock) {
            BushBlock plantBlock = (BushBlock)block;
            BlockState state = plantBlock.defaultBlockState();
            return ((BushBlockAccess)plantBlock).saplanting$invokeCanSurvive(state, (LevelReader)this.level(), pos);
        }
        return this.level().getBlockState(pos).canBeReplaced();
    }

    @Unique
    public void run() {
        block5: {
            ++this.plantAge;
            if (!this.tickCheck()) {
                this.plantAge = 0;
                return;
            }
            if (this.plantAge < CONFIG.getAsInt("plantDelay")) {
                return;
            }
            if (this.roundCheck()) {
                try {
                    this.plant();
                }
                catch (Exception e) {
                    LOGGER.error("Some Errors occurred during planting this item:  ");
                    LOGGER.error(this.getDetail());
                    e.printStackTrace();
                    CONTAIN_ERROR.add(this.getItem().getItem());
                    if (!CONFIG.getAsBoolean("autoBlackList")) break block5;
                    ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)this.getItem().getItem());
                    CONFIG.addToBlackList(id.toString());
                }
            }
        }
        this.plantAge = 0;
    }

    @Unique
    private static void multiThreadRun() {
        try {
            while (Saplanting.THREAD_ALIVE && CONFIG.getAsBoolean("plantEnable") && CONFIG.getAsBoolean("multiThread")) {
                long start = LocalTime.now().getLong(ChronoField.MILLI_OF_DAY);
                while (!CHECK_TASKS.isEmpty() && CONFIG.getAsBoolean("plantEnable") && Saplanting.THREAD_ALIVE && CONFIG.getAsBoolean("multiThread")) {
                    ItemEntityMixin task = CHECK_TASKS.poll();
                    Item item = task.getItem().getItem();
                    if (item instanceof AirItem) continue;
                    task.run();
                }
                long end = LocalTime.now().getLong(ChronoField.MILLI_OF_DAY);
                long delta = end - start;
                long complement = delta < 0L || delta > 20L ? 0L : 20L - delta;
                Thread.sleep(complement);
            }
            LOGGER.info("Saplanting core thread exiting.");
        }
        catch (Exception e) {
            LOGGER.info("Saplanting core thread exited unexpectedly!");
            e.printStackTrace();
        }
        CHECK_TASKS.clear();
        Saplanting.THREAD_ALIVE = false;
    }

    @Unique
    private void addToQueue() {
        int size = CHECK_TASKS.size();
        if (size > CONFIG.getAsInt("maxTask")) {
            CHECK_TASKS.clear();
            if (CONFIG.getAsBoolean("warnTaskQueue")) {
                LOGGER.warn(String.format("Too many items! Cleared %s tasks.", size));
            }
        }
        CHECK_TASKS.add(this);
    }

    @Unique
    private String getDetail() {
        Vec3 pos = this.position();
        Level world = this.level();
        String biomes = world.getBiome(this.blockPosition()).toString();
        String dim = world.dimension().registry().toString();
        Item item = this.getItem().getItem();
        Object output = String.format("ItemEntity: \"%s\" at %s in world \"%s\", biomes \"%s\"\n", this.getDisplayName(), pos, dim, biomes);
        output = (String)output + String.format("Item: \"%s\"(%s)", item.getDefaultInstance().getDisplayName(), BuiltInRegistries.ITEM.getKey((Object)item));
        return output;
    }
}

