/*
 * Decompiled with CFR 0.152.
 */
package cool.muyucloud.saplanting.util;

import com.google.gson.JsonArray;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cool.muyucloud.saplanting.Saplanting;
import cool.muyucloud.saplanting.util.ClientUtil;
import cool.muyucloud.saplanting.util.Config;
import cool.muyucloud.saplanting.util.Translation;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class Command {
    private static final Config CONFIG = Saplanting.getConfig();
    private static final Config DEFAULT_CONFIG = Saplanting.getDefaultConfig();
    private static final Style CLICKABLE_COMMAND = Style.EMPTY.withColor(ChatFormatting.GREEN).withUnderlined(Boolean.valueOf(true));
    private static final Style CLICKABLE_FILE = Style.EMPTY.withUnderlined(Boolean.valueOf(true));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext access, boolean dedicated) {
        LiteralArgumentBuilder root = Commands.literal((String)"saplanting");
        root.requires(source -> source.hasPermission(2));
        root.executes(context -> Command.displayAll(1, (CommandSourceStack)context.getSource()));
        root.then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(context -> Command.displayAll(IntegerArgumentType.getInteger((CommandContext)context, (String)"page"), (CommandSourceStack)context.getSource())));
        LiteralArgumentBuilder property = Commands.literal((String)"property");
        for (String string : CONFIG.getKeySet()) {
            LiteralArgumentBuilder propertyE = Commands.literal((String)string);
            propertyE.executes(context -> Command.getProperty(string, (CommandSourceStack)context.getSource()));
            if (CONFIG.getType(string) == Boolean.class) {
                propertyE.then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> Command.setProperty(string, BoolArgumentType.getBool((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource())));
                propertyE.then(Commands.literal((String)"default").executes(context -> Command.setProperty(string, DEFAULT_CONFIG.getAsBoolean(string), (CommandSourceStack)context.getSource())));
            } else if (CONFIG.getType(string) == Integer.class) {
                propertyE.then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> Command.setProperty(string, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), (CommandSourceStack)context.getSource())));
                propertyE.then(Commands.literal((String)"default").executes(context -> Command.setProperty(string, DEFAULT_CONFIG.getAsInt(string), (CommandSourceStack)context.getSource())));
            }
            property.then((ArgumentBuilder)propertyE);
        }
        root.then((ArgumentBuilder)property);
        LiteralArgumentBuilder language = Commands.literal((String)"language");
        language.executes(context -> Command.queryLanguage((CommandSourceStack)context.getSource()));
        for (String name : CONFIG.getValidLangs()) {
            language.then(Commands.literal((String)name).executes(context -> Command.updateLanguage(name, (CommandSourceStack)context.getSource())));
        }
        language.then(Commands.literal((String)"default").executes(context -> Command.updateLanguage("en_us", (CommandSourceStack)context.getSource())));
        root.then((ArgumentBuilder)language);
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"file");
        literalArgumentBuilder.then(Commands.literal((String)"load").executes(context -> Command.load((CommandSourceStack)context.getSource(), dedicated)));
        literalArgumentBuilder.then(Commands.literal((String)"save").executes(context -> Command.save((CommandSourceStack)context.getSource(), dedicated)));
        root.then((ArgumentBuilder)literalArgumentBuilder);
        LiteralArgumentBuilder blacklist = Commands.literal((String)"blacklist");
        blacklist.executes(context -> Command.displayBlackList(1, (CommandSourceStack)context.getSource()));
        blacklist.then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(context -> Command.displayBlackList(IntegerArgumentType.getInteger((CommandContext)context, (String)"page"), (CommandSourceStack)context.getSource())));
        blacklist.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player == null) {
                return 0;
            }
            Item item = player.getMainHandItem().getItem();
            if (item.equals(Items.AIR)) {
                return 0;
            }
            String value = BuiltInRegistries.ITEM.getKey((Object)item).toString();
            return Command.addToBlackList(value, (CommandSourceStack)context.getSource());
        })).requires(CommandSourceStack::isPlayer)).then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            Set itemIds = BuiltInRegistries.ITEM.keySet();
            for (ResourceLocation id : itemIds) {
                builder.suggest(id.toString());
            }
            builder.suggest("*");
            return builder.buildFuture();
        }).executes(context -> Command.addToBlackList(StringArgumentType.getString((CommandContext)context, (String)"item"), (CommandSourceStack)context.getSource()))));
        blacklist.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"remove").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player == null) {
                return 0;
            }
            Item item = player.getMainHandItem().getItem();
            if (item.equals(Items.AIR)) {
                return 0;
            }
            String value = BuiltInRegistries.ITEM.getKey((Object)item).toString();
            return Command.removeFromBlackList(value, (CommandSourceStack)context.getSource());
        })).requires(CommandSourceStack::isPlayer)).then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            Set itemIds = BuiltInRegistries.ITEM.keySet();
            for (ResourceLocation id : itemIds) {
                builder.suggest(id.toString());
            }
            builder.suggest("*");
            return builder.buildFuture();
        }).executes(context -> Command.removeFromBlackList(StringArgumentType.getString((CommandContext)context, (String)"item"), (CommandSourceStack)context.getSource()))));
        blacklist.then(Commands.literal((String)"clear").executes(context -> Command.clearBlackList((CommandSourceStack)context.getSource())));
        root.then((ArgumentBuilder)blacklist);
        LiteralArgumentBuilder whitelist = Commands.literal((String)"whitelist");
        whitelist.executes(context -> Command.displayWhitelist((CommandSourceStack)context.getSource(), 1));
        whitelist.then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(context -> Command.displayWhitelist((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"page"))));
        whitelist.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player == null) {
                return 0;
            }
            Item item = player.getMainHandItem().getItem();
            if (item.equals(Items.AIR)) {
                return 0;
            }
            String value = BuiltInRegistries.ITEM.getKey((Object)item).toString();
            return Command.addToWhitelist(value, (CommandSourceStack)context.getSource());
        })).requires(CommandSourceStack::isPlayer)).then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            Set itemIds = BuiltInRegistries.ITEM.keySet();
            for (ResourceLocation id : itemIds) {
                builder.suggest(id.toString());
            }
            builder.suggest("*");
            return builder.buildFuture();
        }).executes(context -> Command.addToWhitelist(StringArgumentType.getString((CommandContext)context, (String)"item"), (CommandSourceStack)context.getSource()))));
        whitelist.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"remove").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            if (player == null) {
                return 0;
            }
            Item item = player.getMainHandItem().getItem();
            if (item.equals(Items.AIR)) {
                return 0;
            }
            String value = BuiltInRegistries.ITEM.getKey((Object)item).toString();
            return Command.removeFromWhitelist(value, (CommandSourceStack)context.getSource());
        })).requires(CommandSourceStack::isPlayer)).then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            Set itemIds = BuiltInRegistries.ITEM.keySet();
            for (ResourceLocation id : itemIds) {
                builder.suggest(id.toString());
            }
            builder.suggest("*");
            return builder.buildFuture();
        }).executes(context -> Command.removeFromWhitelist(StringArgumentType.getString((CommandContext)context, (String)"item"), (CommandSourceStack)context.getSource()))));
        whitelist.then(Commands.literal((String)"clear").executes(context -> Command.clearWhitelist((CommandSourceStack)context.getSource())));
        root.then((ArgumentBuilder)whitelist);
        dispatcher.register(root);
    }

    private static int setProperty(String key, boolean value, CommandSourceStack source) {
        if (CONFIG.set(key, value)) {
            MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.property.set.success").formatted(key, Boolean.toString(value)));
            MutableComponent hover = Component.literal((String)Translation.translate("config.saplanting.property.%s".formatted(key)));
            text.setStyle(Style.EMPTY.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hover)));
            Command.sendFeedback(source, (Component)text, false);
        } else {
            MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.property.set.already").formatted(key, Boolean.toString(value)));
            source.sendFailure((Component)text);
        }
        return value ? 1 : 0;
    }

    private static int setProperty(String key, int value, CommandSourceStack source) {
        if (CONFIG.set(key, value)) {
            MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.property.set.success").formatted(key, Integer.toString(value)));
            MutableComponent hover = Component.literal((String)Translation.translate("config.saplanting.property.%s".formatted(key)));
            text.setStyle(Style.EMPTY.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hover)));
            Command.sendFeedback(source, (Component)text, false);
        } else {
            MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.property.set.already").formatted(key, Integer.toString(value)));
            source.sendFailure((Component)text);
        }
        return value;
    }

    private static int getProperty(String key, CommandSourceStack source) {
        MutableComponent hover = Component.literal((String)Translation.translate("config.saplanting.property.%s".formatted(key)));
        MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.property.get").formatted(key, CONFIG.getAsString(key)));
        text.setStyle(Style.EMPTY.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hover)));
        Command.sendFeedback(source, (Component)text, false);
        return 1;
    }

    private static int updateLanguage(String name, CommandSourceStack source) {
        if (!CONFIG.set("language", name)) {
            MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.language.already").formatted(name));
            source.sendFailure((Component)text);
            return 0;
        }
        Translation.updateLanguage(name);
        MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.language.success").formatted(name));
        Command.sendFeedback(source, (Component)text, false);
        return 1;
    }

    private static int queryLanguage(CommandSourceStack source) {
        MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.language.query").formatted(CONFIG.getAsString("language")));
        MutableComponent change = Component.literal((String)Translation.translate("command.saplanting.language.switch")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/saplanting language switch ")));
        Command.sendFeedback(source, (Component)text.append((Component)change), false);
        return 1;
    }

    private static int load(CommandSourceStack source, boolean dedicated) throws CommandSyntaxException {
        MutableComponent hover = Component.literal((String)Translation.translate("command.saplanting.file.open"));
        MutableComponent file = Component.literal((String)CONFIG.stringConfigPath());
        if (Command.isLocal(source, dedicated)) {
            file.setStyle(CLICKABLE_FILE.withClickEvent((ClickEvent)new ClickEvent.OpenFile(CONFIG.stringConfigPath())).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hover)));
        }
        MutableComponent query = Component.literal((String)Translation.translate("command.saplanting.file.load.query")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting")));
        if (CONFIG.load()) {
            MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.file.load.success"));
            if (!dedicated) {
                text.append((Component)file);
            }
            text.append(" ").append((Component)query);
            Command.sendFeedback(source, (Component)text, false, dedicated);
            return 1;
        }
        MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.file.load.fail"));
        if (!dedicated) {
            text.append((Component)file);
        }
        source.sendFailure((Component)text);
        return 0;
    }

    private static int save(CommandSourceStack source, boolean dedicated) {
        MutableComponent hover = Component.literal((String)Translation.translate("commands.saplanting.file.open"));
        MutableComponent file = Component.literal((String)CONFIG.stringConfigPath());
        if (Command.isLocal(source, dedicated)) {
            file.setStyle(CLICKABLE_FILE.withClickEvent((ClickEvent)new ClickEvent.OpenFile(CONFIG.stringConfigPath())).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hover)));
        }
        if (CONFIG.save()) {
            MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.file.save.success"));
            if (!dedicated) {
                text.append((Component)file);
            }
            Command.sendFeedback(source, (Component)text, false, dedicated);
            return 1;
        }
        MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.file.save.fail"));
        if (!dedicated) {
            text.append((Component)file);
        }
        source.sendFailure((Component)text);
        return 0;
    }

    private static int displayAll(int page, CommandSourceStack source) {
        List arr = CONFIG.getKeySet().stream().toList();
        if ((page - 1) * 8 > arr.size() || page < 1) {
            MutableComponent pageError = Component.literal((String)Translation.translate("command.saplanting.page404"));
            source.sendFailure((Component)pageError);
            return 0;
        }
        MutableComponent title = Component.literal((String)Translation.translate("command.saplanting.title")).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
        Command.sendFeedback(source, (Component)title, false);
        for (int i = (page - 1) * 8; i < page * 8 && i < arr.size(); ++i) {
            String key = (String)arr.get(i);
            MutableComponent head = Component.literal((String)"- ");
            MutableComponent reset = Component.literal((String)Translation.translate("command.saplanting.reset")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting property %s default".formatted(key))).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)Translation.translate("command.saplanting.reset.hover").formatted(DEFAULT_CONFIG.getAsString(key))))));
            MutableComponent hover = Component.literal((String)Translation.translate("config.saplanting.property.%s".formatted(key)));
            MutableComponent property = Component.literal((String)key).setStyle(CLICKABLE_COMMAND.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hover)).withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/saplanting property %s ".formatted(key))));
            MutableComponent value = Component.literal((String)(": " + CONFIG.getAsString(key)));
            head.append((Component)reset).append(" ").append((Component)property).append((Component)value);
            Command.sendFeedback(source, (Component)head, false);
        }
        MutableComponent next = Component.literal((String)Translation.translate("command.saplanting.next")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting " + (page + 1))));
        MutableComponent former = Component.literal((String)Translation.translate("command.saplanting.former")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting " + (page - 1))));
        MutableComponent foot = arr.size() <= 8 ? Component.literal((String)" 1 ") : (page == 1 ? Component.literal((String)" 1 >> ").append((Component)next) : (page * 8 >= arr.size() ? Component.literal((String)" ").append((Component)former).append(" << %d ".formatted(page)) : Component.literal((String)" ").append((Component)former).append(" << %d >> ".formatted(page)).append((Component)next)));
        Command.sendFeedback(source, (Component)foot, false);
        return page;
    }

    private static int addToBlackList(String id, CommandSourceStack source) {
        if (CONFIG.addToBlackList(id)) {
            MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.blacklist.add.success").formatted(id));
            MutableComponent undo = Component.literal((String)Translation.translate("command.saplanting.list.click.remove")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting blacklist remove %s".formatted(Config.formatItemLike(id)))));
            Command.sendFeedback(source, (Component)text.append(" ").append((Component)undo), false);
            return 1;
        }
        MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.blacklist.add.error").formatted(id));
        source.sendFailure((Component)text);
        return 0;
    }

    private static int removeFromBlackList(String id, CommandSourceStack source) {
        if (CONFIG.removeFromBlackList(id)) {
            MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.blacklist.remove.success").formatted(id));
            MutableComponent undo = Component.literal((String)Translation.translate("command.saplanting.list.click.undo")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting blacklist add %s".formatted(Config.formatItemLike(id)))));
            Command.sendFeedback(source, (Component)text.append(" ").append((Component)undo), false);
            return 1;
        }
        MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.blacklist.remove.notExist").formatted(id));
        source.sendFailure((Component)text);
        return 0;
    }

    private static int displayBlackList(int page, CommandSourceStack source) {
        if (CONFIG.blacklistSize() == 0) {
            source.sendFailure((Component)Component.literal((String)Translation.translate("command.saplanting.blacklist.empty")));
            return 0;
        }
        JsonArray blacklist = CONFIG.getBlackList();
        if ((page - 1) * 8 > blacklist.size() || page < 1) {
            MutableComponent pageError = Component.literal((String)Translation.translate("command.saplanting.page404"));
            source.sendFailure((Component)pageError);
            return 0;
        }
        MutableComponent title = Component.literal((String)Translation.translate("command.saplanting.blacklist.title"));
        Command.sendFeedback(source, (Component)title, false);
        for (int i = (page - 1) * 8; i < page * 8 && i < blacklist.size(); ++i) {
            String id = blacklist.get(i).getAsString();
            MutableComponent head = Component.literal((String)"- ");
            MutableComponent remove = Component.literal((String)Translation.translate("command.saplanting.list.click.remove"));
            remove.setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting blacklist remove %s".formatted(id))));
            MutableComponent item = Component.literal((String)id);
            Command.sendFeedback(source, (Component)head.append((Component)remove).append(" ").append((Component)item), false);
        }
        MutableComponent next = Component.literal((String)Translation.translate("command.saplanting.next")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting blacklist " + (page + 1))));
        MutableComponent former = Component.literal((String)Translation.translate("command.saplanting.former")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting blacklist " + (page - 1))));
        MutableComponent foot = blacklist.size() <= 8 ? Component.literal((String)" 1 ") : (page == 1 ? Component.literal((String)" 1 >> ").append((Component)next) : (page * 8 > blacklist.size() ? Component.literal((String)" ").append((Component)former).append(" << %d ".formatted(page)) : Component.literal((String)" ").append((Component)former).append(" << %d >> ".formatted(page)).append((Component)next)));
        Command.sendFeedback(source, (Component)foot, false);
        return CONFIG.blacklistSize();
    }

    private static int clearBlackList(CommandSourceStack source) {
        if (CONFIG.blacklistSize() == 0) {
            source.sendFailure((Component)Component.literal((String)Translation.translate("command.saplanting.blacklist.empty")));
            return 0;
        }
        int i = CONFIG.blacklistSize();
        MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.blacklist.clear"));
        Command.sendFeedback(source, (Component)text, false);
        CONFIG.clearBlackList();
        return i;
    }

    private static int addToWhitelist(String id, CommandSourceStack source) {
        if (CONFIG.addToWhitelist(id)) {
            MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.whitelist.add.success").formatted(id));
            MutableComponent undo = Component.literal((String)Translation.translate("command.saplanting.list.click.undo")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting whitelist remove %s".formatted(Config.formatItemLike(id)))));
            Command.sendFeedback(source, (Component)text.append(" ").append((Component)undo), false);
            return 1;
        }
        MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.whitelist.add.error").formatted(id));
        source.sendFailure((Component)text);
        return 0;
    }

    private static int removeFromWhitelist(String id, CommandSourceStack source) {
        if (CONFIG.removeFromWhitelist(id)) {
            MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.whitelist.remove.success").formatted(id));
            MutableComponent undo = Component.literal((String)Translation.translate("command.saplanting.list.click.undo")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting whitelist add %s".formatted(Config.formatItemLike(id)))));
            Command.sendFeedback(source, (Component)text.append(" ").append((Component)undo), false);
            return 1;
        }
        MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.whitelist.remove.notExist").formatted(id));
        source.sendFailure((Component)text);
        return 0;
    }

    private static int displayWhitelist(CommandSourceStack source, int page) {
        if (CONFIG.whitelistSize() == 0) {
            source.sendFailure((Component)Component.literal((String)Translation.translate("command.saplanting.whitelist.empty")));
            return 0;
        }
        JsonArray whitelist = CONFIG.getWhitelist();
        if ((page - 1) * 8 > whitelist.size() || page < 1) {
            MutableComponent pageError = Component.literal((String)Translation.translate("command.saplanting.page404"));
            source.sendFailure((Component)pageError);
            return 0;
        }
        MutableComponent title = Component.literal((String)Translation.translate("command.saplanting.whitelist.title"));
        Command.sendFeedback(source, (Component)title, false);
        for (int i = (page - 1) * 8; i < page * 8 && i < whitelist.size(); ++i) {
            String id = whitelist.get(i).getAsString();
            MutableComponent head = Component.literal((String)"- ");
            MutableComponent remove = Component.literal((String)Translation.translate("command.saplanting.list.click.remove"));
            remove.setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting whitelist remove %s".formatted(id))));
            MutableComponent item = Component.literal((String)id);
            Command.sendFeedback(source, (Component)head.append((Component)remove).append(" ").append((Component)item), false);
        }
        MutableComponent next = Component.literal((String)Translation.translate("command.saplanting.next")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting whitelist " + (page + 1))));
        MutableComponent former = Component.literal((String)Translation.translate("command.saplanting.former")).setStyle(CLICKABLE_COMMAND.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/saplanting whitelist " + (page - 1))));
        MutableComponent foot = whitelist.size() <= 8 ? Component.literal((String)" 1 ") : (page == 1 ? Component.literal((String)" 1 >> ").append((Component)next) : (page * 8 > whitelist.size() ? Component.literal((String)" ").append((Component)former).append(" << %d ".formatted(page)) : Component.literal((String)" ").append((Component)former).append(" << %d >> ".formatted(page)).append((Component)next)));
        Command.sendFeedback(source, (Component)foot, false);
        return CONFIG.whitelistSize();
    }

    private static int clearWhitelist(CommandSourceStack source) {
        if (CONFIG.whitelistSize() == 0) {
            source.sendFailure((Component)Component.literal((String)Translation.translate("command.saplanting.whitelist.empty")));
            return 0;
        }
        int i = CONFIG.whitelistSize();
        MutableComponent text = Component.literal((String)Translation.translate("command.saplanting.whitelist.clear"));
        Command.sendFeedback(source, (Component)text, false);
        CONFIG.clearWhitelist();
        return i;
    }

    private static void sendFeedback(CommandSourceStack source, Component text, boolean broadcastToOps) {
        Command.sendFeedback(source, text, broadcastToOps, true);
    }

    private static void sendFeedback(CommandSourceStack source, Component text, boolean broadcastToOps, boolean dedicated) {
        if (Command.isLocal(source, dedicated)) {
            ClientUtil.message(text, false);
        } else {
            source.sendSuccess(() -> text, broadcastToOps);
        }
    }

    public static boolean isLocal(CommandSourceStack source, boolean dedicated) {
        Player player;
        Entity entity;
        return !dedicated && (entity = source.getEntity()) instanceof Player && ClientUtil.isLocalPlayer((player = (Player)entity).getUUID());
    }
}

